/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.exporters.otlp;

import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.LongExemplarData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.metrics.IntMetric;
import org.apache.ignite.internal.metrics.exporters.otlp.IgniteGaugeData;
import org.apache.ignite.internal.metrics.exporters.otlp.IgniteMetricData;
import org.apache.ignite.internal.metrics.exporters.otlp.IgnitePointData;
import org.apache.ignite.internal.util.Lazy;

class IgniteIntMetricData
extends IgniteMetricData<IntMetric> {
    private final Data<IgniteIntPointData> data;

    IgniteIntMetricData(Lazy<Resource> resource, InstrumentationScopeInfo scope, IntMetric metric) {
        super(resource, scope, metric);
        this.data = new IgniteGaugeData<IgniteIntPointData>(new IgniteIntPointData(metric));
    }

    public MetricDataType getType() {
        return MetricDataType.LONG_GAUGE;
    }

    public Data<?> getData() {
        return this.data;
    }

    private static class IgniteIntPointData
    extends IgnitePointData
    implements LongPointData {
        private final IntMetric metric;

        IgniteIntPointData(IntMetric metric) {
            this.metric = metric;
        }

        public long getValue() {
            return this.metric.value();
        }

        public List<LongExemplarData> getExemplars() {
            return Collections.emptyList();
        }
    }
}

