/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.sql;

import java.time.ZoneId;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.shaded.org.apache.ignite.internal.sql.SqlCommon;
import org.apache.ignite.shaded.org.apache.ignite.internal.sql.StatementBuilderImpl;
import org.apache.ignite.shaded.org.apache.ignite.sql.Statement;

public class StatementImpl
implements Statement {
    private static final long DEFAULT_QUERY_TIMEOUT = 0L;
    private final String query;
    private final String defaultSchema;
    private final long queryTimeoutMs;
    private final int pageSize;
    private final ZoneId timeZoneId;

    public StatementImpl(String query) {
        this(query, null, null, null, null);
    }

    StatementImpl(String query, String defaultSchema, Long queryTimeoutMs, Integer pageSize, ZoneId timeZoneId) {
        this.query = Objects.requireNonNull(query, "Parameter 'query' cannot be null");
        this.defaultSchema = Objects.requireNonNullElse(defaultSchema, SqlCommon.DEFAULT_SCHEMA_NAME);
        this.queryTimeoutMs = Objects.requireNonNullElse(queryTimeoutMs, 0L);
        this.pageSize = Objects.requireNonNullElse(pageSize, 1024);
        this.timeZoneId = Objects.requireNonNullElse(timeZoneId, ZoneId.systemDefault());
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public long queryTimeout(TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit);
        return timeUnit.convert(this.queryTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public String defaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public ZoneId timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public Statement.StatementBuilder toBuilder() {
        return new StatementBuilderImpl().query(this.query).defaultSchema(this.defaultSchema).timeZoneId(this.timeZoneId).pageSize(this.pageSize).queryTimeout(this.queryTimeoutMs, TimeUnit.MILLISECONDS);
    }
}

