/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.apache.ignite.Ignite;
import org.apache.ignite.InitParameters;
import org.apache.ignite.internal.app.IgniteServerImpl;
import org.jetbrains.annotations.Nullable;

public interface IgniteServer {
    public static CompletableFuture<IgniteServer> startAsync(String nodeName, Path configPath, Path workDir) {
        IgniteServer server = IgniteServer.builder(nodeName, configPath, workDir).build();
        return server.startAsync().thenApply(unused -> server);
    }

    public CompletableFuture<Void> startAsync();

    public static IgniteServer start(String nodeName, Path configPath, Path workDir) {
        IgniteServer server = IgniteServer.builder(nodeName, configPath, workDir).build();
        server.start();
        return server;
    }

    public void start();

    public static Builder builder(String nodeName, Path configPath, Path workDir) {
        return new Builder(nodeName, configPath, workDir);
    }

    public Ignite api();

    public CompletableFuture<Void> initClusterAsync(InitParameters var1);

    public void initCluster(InitParameters var1);

    public CompletableFuture<Void> waitForInitAsync();

    public CompletableFuture<Void> shutdownAsync();

    public void shutdown();

    public String name();

    public static final class Builder {
        private final String nodeName;
        private final Path configPath;
        private final Path workDir;
        @Nullable
        private ClassLoader serviceLoaderClassLoader;
        private Executor asyncContinuationExecutor = ForkJoinPool.commonPool();

        private Builder(String nodeName, Path configPath, Path workDir) {
            this.nodeName = nodeName;
            this.configPath = configPath;
            this.workDir = workDir;
        }

        public Builder serviceLoaderClassLoader(@Nullable ClassLoader serviceLoaderClassLoader) {
            this.serviceLoaderClassLoader = serviceLoaderClassLoader;
            return this;
        }

        public Builder asyncContinuationExecutor(Executor asyncContinuationExecutor) {
            this.asyncContinuationExecutor = asyncContinuationExecutor;
            return this;
        }

        public IgniteServer build() {
            return new IgniteServerImpl(this.nodeName, this.configPath, this.workDir, this.serviceLoaderClassLoader, this.asyncContinuationExecutor);
        }
    }
}

