/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.ChangeIndexStatusValidationException;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.MakeIndexAvailableCommandBuilder;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.storage.MakeIndexAvailableEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;

public class MakeIndexAvailableCommand
implements CatalogCommand {
    private final int indexId;

    public static MakeIndexAvailableCommandBuilder builder() {
        return new Builder();
    }

    private MakeIndexAvailableCommand(int indexId) {
        this.indexId = indexId;
    }

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        CatalogIndexDescriptor index = CatalogUtils.indexOrThrow(catalog, this.indexId);
        if (index.status() != CatalogIndexStatus.BUILDING) {
            throw new ChangeIndexStatusValidationException(this.indexId, index.status(), CatalogIndexStatus.AVAILABLE, CatalogIndexStatus.BUILDING);
        }
        return List.of(new MakeIndexAvailableEntry(this.indexId));
    }

    private static class Builder
    implements MakeIndexAvailableCommandBuilder {
        private int indexId;

        private Builder() {
        }

        @Override
        public Builder indexId(int indexId) {
            this.indexId = indexId;
            return this;
        }

        @Override
        public CatalogCommand build() {
            return new MakeIndexAvailableCommand(this.indexId);
        }
    }
}

