/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.commands;

import java.util.HashSet;
import java.util.List;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogParamsValidationUtils;
import org.apache.ignite.internal.catalog.CatalogValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractIndexCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexStatus;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.storage.NewIndexEntry;
import org.apache.ignite.internal.catalog.storage.ObjectIdGenUpdateEntry;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.util.CollectionUtils;

public abstract class AbstractCreateIndexCommand
extends AbstractIndexCommand {
    protected final String tableName;
    protected final boolean unique;
    protected final List<String> columns;
    protected final boolean isCreatedWithTable;
    private final boolean ifNotExists;

    AbstractCreateIndexCommand(String schemaName, String indexName, boolean ifNotExists, String tableName, boolean unique, List<String> columns, boolean isCreatedWithTable) throws CatalogValidationException {
        super(schemaName, indexName);
        AbstractCreateIndexCommand.validate(tableName, columns);
        this.ifNotExists = ifNotExists;
        this.tableName = tableName;
        this.unique = unique;
        this.columns = CollectionUtils.copyOrNull(columns);
        this.isCreatedWithTable = isCreatedWithTable;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    protected abstract CatalogIndexDescriptor createDescriptor(int var1, int var2, CatalogIndexStatus var3);

    @Override
    public List<UpdateEntry> get(Catalog catalog) {
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, this.schemaName);
        CatalogParamsValidationUtils.ensureNoTableIndexOrSysViewExistsWithGivenName(schema, this.indexName);
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(schema, this.tableName);
        assert (this.columns != null);
        for (String columnName : this.columns) {
            if (table.column(columnName) != null) continue;
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Column with name '{}' not found in table '{}.{}'", (Object[])new Object[]{columnName, this.schemaName, this.tableName}));
        }
        if (this.unique && !new HashSet<String>(this.columns).containsAll(table.colocationColumns())) {
            throw new CatalogValidationException("Unique index must include all colocation columns");
        }
        CatalogIndexStatus status = this.isCreatedWithTable ? CatalogIndexStatus.AVAILABLE : CatalogIndexStatus.REGISTERED;
        return List.of(new NewIndexEntry(this.createDescriptor(catalog.objectIdGenState(), table.id(), status)), new ObjectIdGenUpdateEntry(1));
    }

    private static void validate(String tableName, List<String> columns) {
        CatalogParamsValidationUtils.validateIdentifier(tableName, "Name of the table");
        if (CollectionUtils.nullOrEmpty(columns)) {
            throw new CatalogValidationException("Columns not specified");
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (String name : columns) {
            CatalogParamsValidationUtils.validateIdentifier(name, "Name of the column");
            if (columnNames.add(name)) continue;
            throw new CatalogValidationException(IgniteStringFormatter.format((String)"Column with name '{}' specified more than once", (Object[])new Object[]{name}));
        }
    }
}

