/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory;

import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.pagememory.reuse.ReuseBag;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageIdUtils;
import org.jetbrains.annotations.Nullable;

public interface PageIdAllocator {
    public static final byte FLAG_DATA = 1;
    public static final byte FLAG_AUX = 2;
    public static final int MAX_PARTITION_ID = 65500;

    public long allocatePageNoReuse(int var1, int var2, byte var3) throws IgniteInternalCheckedException;

    default public long allocatePage(@Nullable ReuseList reuseList, int groupId, int partitionId, byte flags) throws IgniteInternalCheckedException {
        return this.allocatePage(reuseList, null, true, groupId, partitionId, flags);
    }

    default public long allocatePage(@Nullable ReuseList reuseList, @Nullable ReuseBag bag, boolean useRecycled, int groupId, int partitionId, byte flags) throws IgniteInternalCheckedException {
        long pageId = 0L;
        if (useRecycled && reuseList != null) {
            long l = pageId = bag != null ? bag.pollFreePage() : 0L;
            if (pageId == 0L) {
                pageId = reuseList.takeRecycledPage();
            }
            if (pageId != 0L) {
                pageId = PageIdAllocator.replacePartitionId(pageId, partitionId);
                pageId = reuseList.initRecycledPage(pageId, flags, null);
            }
        }
        if (pageId == 0L) {
            pageId = this.allocatePageNoReuse(groupId, partitionId, flags);
        }
        if (!1.$assertionsDisabled && pageId == 0L) {
            throw new AssertionError();
        }
        if (!(1.$assertionsDisabled || PageIdUtils.partitionId(pageId) >= 0 && PageIdUtils.partitionId(pageId) <= 65500)) {
            throw new AssertionError((Object)PageIdUtils.toDetailString(pageId));
        }
        if (!1.$assertionsDisabled && PageIdUtils.flag(pageId) == 1 && PageIdUtils.itemId(pageId) != 0) {
            throw new AssertionError((Object)PageIdUtils.toDetailString(pageId));
        }
        return pageId;
    }

    private static long replacePartitionId(long pageId, int partId) {
        long partitionIdZeroMask = -281470681743361L;
        long partitionIdMask = (long)partId << 32;
        return pageId & partitionIdZeroMask | partitionIdMask;
    }

    public boolean freePage(int var1, long var2);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

