/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.NetworkMessageHandler;
import org.apache.ignite.internal.thread.ThreadAttributes;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.tostring.IgniteToStringBuilder;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

public class TrackableNetworkMessageHandler
implements NetworkMessageHandler {
    private static final IgniteLogger LOG = Loggers.forClass(TrackableNetworkMessageHandler.class);
    private static final int MESSAGING_PROCESSING_LOG_THRESHOLD_MILLIS = 5;
    private final NetworkMessageHandler targetHandler;

    TrackableNetworkMessageHandler(NetworkMessageHandler targetHandler) {
        this.targetHandler = targetHandler;
    }

    @Override
    public void onReceived(NetworkMessage message, ClusterNode sender, @Nullable Long correlationId) {
        long startTimeNanos = System.nanoTime();
        this.targetHandler.onReceived(message, sender, correlationId);
        if (!TrackableNetworkMessageHandler.storageThread()) {
            TrackableNetworkMessageHandler.maybeLogLongProcessing(message, startTimeNanos);
        }
    }

    private static boolean storageThread() {
        Thread currentThread = Thread.currentThread();
        if (!(currentThread instanceof ThreadAttributes)) {
            return false;
        }
        ThreadAttributes current = (ThreadAttributes)currentThread;
        Set allowedOperations = current.allowedOperations();
        return allowedOperations.contains(ThreadOperation.STORAGE_READ) || allowedOperations.contains(ThreadOperation.STORAGE_WRITE) || allowedOperations.contains(ThreadOperation.TX_STATE_STORAGE_ACCESS);
    }

    private static void maybeLogLongProcessing(NetworkMessage message, long startTimeNanos) {
        long durationMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNanos);
        if (durationMillis > 5L) {
            LOG.warn("Message handling has been too long [duration={}ms, message={}]", new Object[]{durationMillis, LOG.isDebugEnabled() && IgniteToStringBuilder.includeSensitive() ? message : message.toStringForLightLogging()});
        }
    }
}

