/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.lang;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.ignite.shaded.org.jetbrains.annotations.Nullable;

public final class IgniteSystemProperties {
    public static final String IGNITE_SENSITIVE_DATA_LOGGING = "IGNITE_SENSITIVE_DATA_LOGGING";
    public static final String IGNITE_TO_STRING_COLLECTION_LIMIT = "IGNITE_TO_STRING_COLLECTION_LIMIT";
    public static final String IGNITE_TO_STRING_IGNORE_RUNTIME_EXCEPTION = "IGNITE_TO_STRING_IGNORE_RUNTIME_EXCEPTION";
    public static final String IGNITE_TO_STRING_MAX_LENGTH = "IGNITE_TO_STRING_MAX_LENGTH";
    public static final String THREAD_ASSERTIONS_ENABLED = "IGNITE_THREAD_ASSERTIONS_ENABLED";
    public static final String THREAD_ASSERTIONS_LOG_BEFORE_THROWING = "THREAD_ASSERTIONS_LOG_BEFORE_THROWING";
    public static final String IGNITE_SKIP_REPLICATION_IN_BENCHMARK = "IGNITE_SKIP_REPLICATION_IN_BENCHMARK";
    public static final String IGNITE_SKIP_STORAGE_UPDATE_IN_BENCHMARK = "IGNITE_SKIP_STORAGE_UPDATE_IN_BENCHMARK";

    private IgniteSystemProperties() {
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumCls, String name) {
        return IgniteSystemProperties.getEnum(enumCls, name, null);
    }

    public static <E extends Enum<E>> E getEnum(String name, E dflt) {
        return IgniteSystemProperties.getEnum(dflt.getDeclaringClass(), name, dflt);
    }

    private static <E extends Enum<E>> E getEnum(Class<E> enumCls, String name, E dflt) {
        assert (enumCls != null);
        String val = IgniteSystemProperties.getString(name);
        if (val == null) {
            return dflt;
        }
        try {
            return Enum.valueOf(enumCls, val);
        }
        catch (IllegalArgumentException ignore) {
            return dflt;
        }
    }

    @Nullable
    public static String getString(String name) {
        assert (name != null);
        String v = System.getProperty(name);
        if (v == null) {
            v = System.getenv(name);
        }
        return v;
    }

    public static String getString(String name, String dflt) {
        String val = IgniteSystemProperties.getString(name);
        return val == null ? dflt : val;
    }

    public static boolean getBoolean(String name) {
        return IgniteSystemProperties.getBoolean(name, false);
    }

    public static boolean getBoolean(String name, boolean dflt) {
        String val = IgniteSystemProperties.getString(name);
        return val == null ? dflt : Boolean.parseBoolean(val);
    }

    public static int getInteger(String name, int dflt) {
        int res;
        String s2 = IgniteSystemProperties.getString(name);
        if (s2 == null) {
            return dflt;
        }
        try {
            res = Integer.parseInt(s2);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static float getFloat(String name, float dflt) {
        float res;
        String s2 = IgniteSystemProperties.getString(name);
        if (s2 == null) {
            return dflt;
        }
        try {
            res = Float.parseFloat(s2);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static long getLong(String name, long dflt) {
        long res;
        String s2 = IgniteSystemProperties.getString(name);
        if (s2 == null) {
            return dflt;
        }
        try {
            res = Long.parseLong(s2);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static double getDouble(String name, double dflt) {
        double res;
        String s2 = IgniteSystemProperties.getString(name);
        if (s2 == null) {
            return dflt;
        }
        try {
            res = Double.parseDouble(s2);
        }
        catch (NumberFormatException ignore) {
            res = dflt;
        }
        return res;
    }

    public static Properties snapshot() {
        Properties sysProps = (Properties)System.getProperties().clone();
        Iterator<Map.Entry<Object, Object>> iter = sysProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            if (entry.getValue() instanceof String && entry.getKey() instanceof String) continue;
            iter.remove();
        }
        return sysProps;
    }
}

