/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.core;

import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.apache.ignite.raft.jraft.Node;
import org.apache.ignite.raft.jraft.NodeManager;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftServerService;
import org.apache.ignite.raft.jraft.rpc.RpcContext;
import org.apache.ignite.raft.jraft.rpc.RpcProcessor;
import org.apache.ignite.raft.jraft.rpc.RpcRequestClosure;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;
import org.apache.ignite.raft.jraft.rpc.impl.ConnectionClosedEventListener;
import org.apache.ignite.raft.jraft.rpc.impl.core.NodeRequestProcessor;
import org.apache.ignite.raft.jraft.util.Utils;
import org.apache.ignite.raft.jraft.util.concurrent.SingleThreadExecutor;

public class AppendEntriesRequestProcessor
extends NodeRequestProcessor<RpcRequests.AppendEntriesRequest>
implements ConnectionClosedEventListener {
    private final Map<String, Map<String, PeerPair>> pairConstants = new HashMap<String, Map<String, PeerPair>>();
    private final ConcurrentMap<String, ConcurrentMap<PeerPair, PeerRequestContext>> peerRequestContexts = new ConcurrentHashMap<String, ConcurrentMap<PeerPair, PeerRequestContext>>();
    private final RpcProcessor.ExecutorSelector executorSelector = new PeerExecutorSelector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerPair pairOf(String peerId, String serverId) {
        Map<String, Map<String, PeerPair>> map = this.pairConstants;
        synchronized (map) {
            Map pairs = this.pairConstants.computeIfAbsent(peerId, k -> new HashMap());
            PeerPair pair = pairs.computeIfAbsent(serverId, k -> new PeerPair(peerId, serverId));
            return pair;
        }
    }

    PeerRequestContext getPeerRequestContext(String groupId, PeerPair pair) {
        ConcurrentMap groupContexts = (ConcurrentMap)this.peerRequestContexts.get(groupId);
        if (groupContexts == null) {
            return null;
        }
        return (PeerRequestContext)groupContexts.get(pair);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendSequenceResponse(String groupId, PeerPair pair, int seq, RpcContext rpcCtx, Message msg) {
        PeerRequestContext ctx = this.getPeerRequestContext(groupId, pair);
        if (ctx == null) {
            return;
        }
        PriorityQueue<SequenceMessage> respQueue = ctx.responseQueue;
        assert (respQueue != null);
        PriorityQueue<SequenceMessage> priorityQueue = Utils.withLockObject(respQueue);
        synchronized (priorityQueue) {
            respQueue.add(new SequenceMessage(rpcCtx, msg, seq));
            if (!ctx.hasTooManyPendingResponses()) {
                while (!respQueue.isEmpty()) {
                    SequenceMessage queuedPipelinedResponse = respQueue.peek();
                    if (queuedPipelinedResponse.sequence == ctx.getNextRequiredSequence()) {
                        respQueue.remove();
                        try {
                            queuedPipelinedResponse.sendResponse();
                            continue;
                        }
                        finally {
                            ctx.getAndIncrementNextRequiredSequence();
                            continue;
                        }
                    }
                    break;
                }
            } else {
                LOG.warn("Dropping pipelined responses to peer {}/{}, because of too many pending responses, queued={}, max={}", new Object[]{ctx.groupId, pair, respQueue.size(), ctx.maxPendingResponses});
                this.removePeerRequestContext(groupId, pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerRequestContext getOrCreatePeerRequestContext(String groupId, PeerPair pair, NodeManager nodeManager) {
        PeerRequestContext peerCtx;
        ConcurrentMap existsCtxs;
        ConcurrentMap<PeerPair, PeerRequestContext> groupContexts = (ConcurrentHashMap)this.peerRequestContexts.get(groupId);
        if (groupContexts == null && (existsCtxs = (ConcurrentMap)this.peerRequestContexts.putIfAbsent(groupId, groupContexts = new ConcurrentHashMap())) != null) {
            groupContexts = existsCtxs;
        }
        if ((peerCtx = (PeerRequestContext)groupContexts.get(pair)) == null) {
            ConcurrentMap concurrentMap = Utils.withLockObject(groupContexts);
            synchronized (concurrentMap) {
                peerCtx = (PeerRequestContext)groupContexts.get(pair);
                if (peerCtx == null) {
                    PeerId peer = new PeerId();
                    boolean parsed = peer.parse(pair.local);
                    assert (parsed);
                    Node node = nodeManager.get(groupId, peer);
                    assert (node != null);
                    peerCtx = new PeerRequestContext(groupId, pair, node.getRaftOptions().getMaxReplicatorInflightMsgs());
                    peerCtx.executor = node.getOptions().getStripedExecutor().next();
                    groupContexts.put(pair, peerCtx);
                }
            }
        }
        return peerCtx;
    }

    void removePeerRequestContext(String groupId, PeerPair pair) {
        ConcurrentMap groupContexts = (ConcurrentMap)this.peerRequestContexts.get(groupId);
        if (groupContexts == null) {
            return;
        }
        groupContexts.remove(pair);
    }

    public AppendEntriesRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(RpcRequests.AppendEntriesRequest request) {
        return request.peerId();
    }

    @Override
    protected String getGroupId(RpcRequests.AppendEntriesRequest request) {
        return request.groupId();
    }

    private int getAndIncrementSequence(String groupId, PeerPair pair, NodeManager nodeManager) {
        return this.getOrCreatePeerRequestContext(groupId, pair, nodeManager).getAndIncrementSequence();
    }

    private boolean isHeartbeatRequest(RpcRequests.AppendEntriesRequest request) {
        return request.entriesList() == null && request.data() == null;
    }

    @Override
    public Message processRequest0(RaftServerService service, RpcRequests.AppendEntriesRequest request, RpcRequestClosure done) {
        Node node = (Node)((Object)service);
        if (node.getRaftOptions().isReplicatorPipeline()) {
            Message response;
            String groupId = request.groupId();
            PeerPair pair = this.pairOf(request.peerId(), request.serverId());
            boolean isHeartbeat = this.isHeartbeatRequest(request);
            int reqSequence = -1;
            if (!isHeartbeat) {
                reqSequence = this.getAndIncrementSequence(groupId, pair, done.getRpcCtx().getNodeManager());
            }
            if ((response = service.handleAppendEntriesRequest(request, new SequenceRpcRequestClosure(done, groupId, pair, reqSequence, isHeartbeat))) != null) {
                if (isHeartbeat) {
                    done.getRpcCtx().sendResponse(response);
                } else {
                    this.sendSequenceResponse(groupId, pair, reqSequence, done.getRpcCtx(), response);
                }
            }
            return null;
        }
        return service.handleAppendEntriesRequest(request, done);
    }

    @Override
    public String interest() {
        return RpcRequests.AppendEntriesRequest.class.getName();
    }

    @Override
    public RpcProcessor.ExecutorSelector executorSelector() {
        return this.executorSelector;
    }

    public void destroy() {
        this.peerRequestContexts.clear();
    }

    @Override
    public void onClosed(String local, String remote) {
        PeerPair pair = new PeerPair(local, remote);
        for (Map.Entry entry : this.peerRequestContexts.entrySet()) {
            ConcurrentMap groupCtxs = (ConcurrentMap)entry.getValue();
            groupCtxs.remove(pair);
        }
    }

    static class PeerRequestContext {
        private final String groupId;
        private final PeerPair pair;
        private SingleThreadExecutor executor;
        private int sequence;
        private int nextRequiredSequence;
        private final PriorityQueue<SequenceMessage> responseQueue;
        private final int maxPendingResponses;

        PeerRequestContext(String groupId, PeerPair pair, int maxPendingResponses) {
            this.pair = pair;
            this.groupId = groupId;
            this.sequence = 0;
            this.nextRequiredSequence = 0;
            this.maxPendingResponses = maxPendingResponses;
            this.responseQueue = new PriorityQueue(50);
        }

        boolean hasTooManyPendingResponses() {
            return this.responseQueue.size() > this.maxPendingResponses;
        }

        int getAndIncrementSequence() {
            int prev = this.sequence++;
            if (this.sequence < 0) {
                this.sequence = 0;
            }
            return prev;
        }

        int getNextRequiredSequence() {
            return this.nextRequiredSequence;
        }

        int getAndIncrementNextRequiredSequence() {
            int prev = this.nextRequiredSequence++;
            if (this.nextRequiredSequence < 0) {
                this.nextRequiredSequence = 0;
            }
            return prev;
        }
    }

    static class PeerPair {
        final String local;
        final String remote;

        PeerPair(String local, String remote) {
            this.local = local;
            this.remote = remote;
        }

        public String toString() {
            return "PeerPair[" + this.local + " -> " + this.remote + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.local == null ? 0 : this.local.hashCode());
            result = 31 * result + (this.remote == null ? 0 : this.remote.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PeerPair other = (PeerPair)obj;
            if (this.local == null ? other.local != null : !this.local.equals(other.local)) {
                return false;
            }
            return !(this.remote == null ? other.remote != null : !this.remote.equals(other.remote));
        }
    }

    static class SequenceMessage
    implements Comparable<SequenceMessage> {
        public final Message msg;
        private final int sequence;
        private final RpcContext rpcCtx;

        SequenceMessage(RpcContext rpcCtx, Message msg, int sequence) {
            this.rpcCtx = rpcCtx;
            this.msg = msg;
            this.sequence = sequence;
        }

        void sendResponse() {
            this.rpcCtx.sendResponse(this.msg);
        }

        @Override
        public int compareTo(SequenceMessage o) {
            return Integer.compare(this.sequence, o.sequence);
        }
    }

    class SequenceRpcRequestClosure
    extends RpcRequestClosure {
        private final int reqSequence;
        private final String groupId;
        private final PeerPair pair;
        private final boolean isHeartbeat;

        SequenceRpcRequestClosure(RpcRequestClosure parent, String groupId, PeerPair pair, int sequence, boolean isHeartbeat) {
            super(parent.getRpcCtx(), parent.getMsgFactory());
            this.reqSequence = sequence;
            this.groupId = groupId;
            this.pair = pair;
            this.isHeartbeat = isHeartbeat;
        }

        @Override
        public void sendResponse(Message msg) {
            if (this.isHeartbeat) {
                super.sendResponse(msg);
            } else {
                AppendEntriesRequestProcessor.this.sendSequenceResponse(this.groupId, this.pair, this.reqSequence, this.getRpcCtx(), msg);
            }
        }
    }

    final class PeerExecutorSelector
    implements RpcProcessor.ExecutorSelector {
        PeerExecutorSelector() {
        }

        @Override
        public Executor select(String reqClass, Object req, NodeManager nodeManager) {
            RpcRequests.AppendEntriesRequest req0 = (RpcRequests.AppendEntriesRequest)req;
            String groupId = req0.groupId();
            String peerId = req0.peerId();
            String serverId = req0.serverId();
            PeerId peer = new PeerId();
            if (!peer.parse(peerId)) {
                return AppendEntriesRequestProcessor.this.executor();
            }
            Node node = nodeManager.get(groupId, peer);
            if (node == null || !node.getRaftOptions().isReplicatorPipeline()) {
                return AppendEntriesRequestProcessor.this.executor();
            }
            PeerPair pair = AppendEntriesRequestProcessor.this.pairOf(peerId, serverId);
            PeerRequestContext ctx = AppendEntriesRequestProcessor.this.getOrCreatePeerRequestContext(groupId, pair, nodeManager);
            return ctx.executor;
        }
    }
}

