/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import org.apache.ignite.internal.pagememory.DataRegion;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.configuration.schema.VolatilePageMemoryDataRegionConfiguration;
import org.apache.ignite.internal.pagememory.evict.PageEvictionTracker;
import org.apache.ignite.internal.pagememory.evict.PageEvictionTrackerNoOp;
import org.apache.ignite.internal.pagememory.inmemory.VolatilePageMemory;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolder;
import org.apache.ignite.internal.pagememory.metric.IoStatisticsHolderNoOp;
import org.apache.ignite.internal.pagememory.reuse.ReuseList;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.pagememory.util.PageLockListenerNoOp;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumnsFreeList;
import org.apache.ignite.internal.storage.pagememory.mv.RowVersionFreeList;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.IgniteInternalCheckedException;

public class VolatilePageMemoryDataRegion
implements DataRegion<VolatilePageMemory> {
    private static final int FREE_LIST_GROUP_ID = 0;
    private static final int FREE_LIST_PARTITION_ID = 0;
    private final VolatilePageMemoryDataRegionConfiguration cfg;
    private final PageIoRegistry ioRegistry;
    private final int pageSize;
    private volatile VolatilePageMemory pageMemory;
    private volatile RowVersionFreeList rowVersionFreeList;
    private volatile IndexColumnsFreeList indexColumnsFreeList;

    public VolatilePageMemoryDataRegion(VolatilePageMemoryDataRegionConfiguration cfg, PageIoRegistry ioRegistry, int pageSize) {
        this.cfg = cfg;
        this.ioRegistry = ioRegistry;
        this.pageSize = pageSize;
    }

    public void start() {
        VolatilePageMemory pageMemory = new VolatilePageMemory(this.cfg, this.ioRegistry, this.pageSize);
        pageMemory.start();
        try {
            this.rowVersionFreeList = VolatilePageMemoryDataRegion.createRowVersionFreeList((PageMemory)pageMemory);
            this.indexColumnsFreeList = this.createIndexColumnsFreeList(pageMemory, (ReuseList)this.rowVersionFreeList);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error creating a RowVersionFreeList", (Throwable)e);
        }
        this.pageMemory = pageMemory;
    }

    private static RowVersionFreeList createRowVersionFreeList(PageMemory pageMemory) throws IgniteInternalCheckedException {
        long metaPageId = pageMemory.allocatePage(0, 0, (byte)2);
        return new RowVersionFreeList(0, 0, pageMemory, null, (PageLockListener)PageLockListenerNoOp.INSTANCE, metaPageId, true, null, (PageEvictionTracker)PageEvictionTrackerNoOp.INSTANCE, (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
    }

    private IndexColumnsFreeList createIndexColumnsFreeList(VolatilePageMemory pageMemory, ReuseList reuseList) throws IgniteInternalCheckedException {
        long metaPageId = pageMemory.allocatePage(0, 0, (byte)2);
        return new IndexColumnsFreeList(0, 0, (PageMemory)pageMemory, reuseList, (PageLockListener)PageLockListenerNoOp.INSTANCE, metaPageId, true, null, (PageEvictionTracker)PageEvictionTrackerNoOp.INSTANCE, (IoStatisticsHolder)IoStatisticsHolderNoOp.INSTANCE);
    }

    public void stop() throws Exception {
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        AutoCloseable autoCloseable = autoCloseableArray[0] = this.pageMemory != null ? () -> this.pageMemory.stop(true) : null;
        autoCloseableArray[1] = this.rowVersionFreeList != null ? () -> ((RowVersionFreeList)this.rowVersionFreeList).close() : null;
        IgniteUtils.closeAll((AutoCloseable[])autoCloseableArray);
    }

    public VolatilePageMemory pageMemory() {
        this.checkDataRegionStarted();
        return this.pageMemory;
    }

    public ReuseList reuseList() {
        return this.rowVersionFreeList();
    }

    public RowVersionFreeList rowVersionFreeList() {
        this.checkDataRegionStarted();
        return this.rowVersionFreeList;
    }

    public IndexColumnsFreeList indexColumnsFreeList() {
        return this.indexColumnsFreeList;
    }

    private void checkDataRegionStarted() {
        if (this.pageMemory == null) {
            throw new StorageException("Data region not started");
        }
    }
}

