/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.rest;

import io.micronaut.http.annotation.Controller;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.ignite.internal.metrics.MetricManager;
import org.apache.ignite.internal.metrics.rest.exception.MetricNotFoundException;
import org.apache.ignite.internal.rest.api.metric.MetricSourceDto;
import org.apache.ignite.internal.rest.api.metric.NodeMetricApi;

@Controller(value="/management/v1/metric/node")
public class NodeMetricController
implements NodeMetricApi {
    private final MetricManager metricManager;

    public NodeMetricController(MetricManager metricManager) {
        this.metricManager = metricManager;
    }

    public void enable(String srcName) {
        try {
            this.metricManager.enable(srcName);
        }
        catch (IllegalStateException e) {
            throw new MetricNotFoundException(e);
        }
    }

    public void disable(String srcName) {
        try {
            this.metricManager.disable(srcName);
        }
        catch (IllegalStateException e) {
            throw new MetricNotFoundException(e);
        }
    }

    public Collection<MetricSourceDto> list() {
        return this.metricManager.metricSources().stream().map(source -> new MetricSourceDto(source.name(), source.enabled())).collect(Collectors.toList());
    }
}

