/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema.marshaller.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.BitSet;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.SchemaMismatchException;
import org.apache.ignite.internal.schema.marshaller.BinaryMode;
import org.apache.ignite.internal.schema.marshaller.MarshallerException;
import org.apache.ignite.internal.schema.marshaller.MarshallerUtil;
import org.apache.ignite.internal.schema.row.Row;
import org.apache.ignite.internal.schema.row.RowAssembler;
import org.apache.ignite.table.mapper.TypeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ColumnBinding {
    private static final MethodHandle NULL_WRITER;
    private static final MethodHandle P_BYTE_READER;
    private static final MethodHandle P_SHORT_READER;
    private static final MethodHandle P_INT_READER;
    private static final MethodHandle P_LONG_READER;
    private static final MethodHandle P_FLOAT_READER;
    private static final MethodHandle P_DOUBLE_READER;
    private static final MethodHandle BYTE_READER;
    private static final MethodHandle SHORT_READER;
    private static final MethodHandle INT_READER;
    private static final MethodHandle LONG_READER;
    private static final MethodHandle FLOAT_READER;
    private static final MethodHandle DOUBLE_READER;
    private static final MethodHandle DECIMAL_READER;
    private static final MethodHandle NUMBER_READER;
    private static final MethodHandle STRING_READER;
    private static final MethodHandle UUID_READER;
    private static final MethodHandle BYTE_ARR_READER;
    private static final MethodHandle BITSET_READER;
    private static final MethodHandle DATE_READER;
    private static final MethodHandle DATETIME_READER;
    private static final MethodHandle TIME_READER;
    private static final MethodHandle TIMESTAMP_READER;
    private static final MethodHandle BYTE_WRITER;
    private static final MethodHandle SHORT_WRITER;
    private static final MethodHandle INT_WRITER;
    private static final MethodHandle LONG_WRITER;
    private static final MethodHandle FLOAT_WRITER;
    private static final MethodHandle DOUBLE_WRITER;
    private static final MethodHandle DECIMAL_WRITER;
    private static final MethodHandle NUMBER_WRITER;
    private static final MethodHandle STRING_WRITER;
    private static final MethodHandle UUID_WRITER;
    private static final MethodHandle BYTE_ARR_WRITER;
    private static final MethodHandle BITSET_WRITER;
    private static final MethodHandle DATE_WRITER;
    private static final MethodHandle DATETIME_WRITER;
    private static final MethodHandle TIME_WRITER;
    private static final MethodHandle TIMESTAMP_WRITER;
    private static final MethodHandle TRANSFORM_BEFORE_WRITE;
    private static final MethodHandle TRANSFORM_AFTER_READ;
    protected final MethodHandle getterHnd;
    protected final MethodHandle setterHnd;
    protected final MethodHandle readerHnd;
    protected final MethodHandle writerHnd;
    protected final int colIdx;

    static ColumnBinding unmappedFieldBinding(Column col) {
        return new UnmappedFieldBinding(col);
    }

    static ColumnBinding createFieldBinding(Column col, Class<?> type, @NotNull String fldName, @Nullable TypeConverter<?, ?> converter) {
        try {
            Field field = type.getDeclaredField(fldName);
            VarHandle varHandle = MethodHandles.privateLookupIn(type, MethodHandles.lookup()).unreflectVarHandle(field);
            if (varHandle.varType().isPrimitive() && col.nullable()) {
                throw new IllegalArgumentException(String.format("Failed to map non-nullable field to nullable column: columnName=%s, fieldName=%s, class=%s", col.name(), fldName, type.getName()));
            }
            return ColumnBinding.create(col, varHandle.varType(), varHandle.toMethodHandle(VarHandle.AccessMode.GET), varHandle.toMethodHandle(VarHandle.AccessMode.SET), converter);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NotNull
    static ColumnBinding createIdentityBinding(Column col, Class<?> type, @Nullable TypeConverter<?, ?> converter) {
        BinaryMode mode = MarshallerUtil.mode(type);
        if (mode.typeSpec() != col.type().spec()) {
            throw new SchemaMismatchException(String.format("Object can't be mapped to a column of incompatible type: columnType=%s, mappedType=%s", new Object[]{col.type().spec(), type.getName()}));
        }
        MethodHandle identityHandle = MethodHandles.identity(type);
        return ColumnBinding.create(col, type, identityHandle, identityHandle, converter);
    }

    @NotNull
    private static ColumnBinding create(Column col, Class<?> type, MethodHandle getterHandle, MethodHandle setterHandle, @Nullable TypeConverter<?, ?> converter) {
        int colIdx = col.schemaIndex();
        switch (MarshallerUtil.mode(type)) {
            case P_BYTE: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, P_BYTE_READER, BYTE_WRITER, converter);
            }
            case P_SHORT: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, P_SHORT_READER, SHORT_WRITER, converter);
            }
            case P_INT: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, P_INT_READER, INT_WRITER, converter);
            }
            case P_LONG: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, P_LONG_READER, LONG_WRITER, converter);
            }
            case P_FLOAT: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, P_FLOAT_READER, FLOAT_WRITER, converter);
            }
            case P_DOUBLE: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, P_DOUBLE_READER, DOUBLE_WRITER, converter);
            }
            case BYTE: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, BYTE_READER, BYTE_WRITER, converter);
            }
            case SHORT: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, SHORT_READER, SHORT_WRITER, converter);
            }
            case INT: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, INT_READER, INT_WRITER, converter);
            }
            case LONG: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, LONG_READER, LONG_WRITER, converter);
            }
            case FLOAT: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, FLOAT_READER, FLOAT_WRITER, converter);
            }
            case DOUBLE: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, DOUBLE_READER, DOUBLE_WRITER, converter);
            }
            case STRING: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, STRING_READER, STRING_WRITER, converter);
            }
            case UUID: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, UUID_READER, UUID_WRITER, converter);
            }
            case BYTE_ARR: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, BYTE_ARR_READER, BYTE_ARR_WRITER, converter);
            }
            case BITSET: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, BITSET_READER, BITSET_WRITER, converter);
            }
            case NUMBER: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, NUMBER_READER, NUMBER_WRITER, converter);
            }
            case DECIMAL: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, DECIMAL_READER, DECIMAL_WRITER, converter);
            }
            case TIME: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, TIME_READER, TIME_WRITER, converter);
            }
            case DATE: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, DATE_READER, DATE_WRITER, converter);
            }
            case DATETIME: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, DATETIME_READER, DATETIME_WRITER, converter);
            }
            case TIMESTAMP: {
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, TIMESTAMP_READER, TIMESTAMP_WRITER, converter);
            }
            case POJO: {
                if (converter == null) {
                    throw new IllegalArgumentException(String.format("Failed to bind column to a POJO class/field without converter: columnName=%s, targetType=%s", col.name(), type));
                }
                return ColumnBinding.create(colIdx, getterHandle, setterHandle, BYTE_ARR_READER, BYTE_ARR_WRITER, converter);
            }
        }
        throw new IllegalArgumentException(String.format("Failed to bind column to a class/field: columnName=%s, targetType=%s", col.name(), type));
    }

    @NotNull
    private static ColumnBinding create(int colIdx, MethodHandle getterHandle, MethodHandle setterHandle, MethodHandle readerHandle, MethodHandle writerHandle, @Nullable TypeConverter<?, ?> converter) {
        if (converter != null) {
            return new TransformingBinding(colIdx, getterHandle, setterHandle, readerHandle, writerHandle, converter);
        }
        if (((Class)readerHandle.type().returnType()).isPrimitive()) {
            return new PrimitiveFieldBinding(colIdx, getterHandle, setterHandle, readerHandle, writerHandle);
        }
        return new DefaultBinding(colIdx, getterHandle, setterHandle, readerHandle, writerHandle);
    }

    private ColumnBinding(int colIdx, MethodHandle getterMtd, MethodHandle setterMtd, MethodHandle readerHnd, MethodHandle writerHnd) {
        assert (colIdx >= 0);
        this.colIdx = colIdx;
        this.getterHnd = getterMtd;
        this.setterHnd = setterMtd;
        this.writerHnd = writerHnd;
        this.readerHnd = readerHnd;
    }

    public void write(RowAssembler writer, Object obj) throws MarshallerException {
        try {
            this.write0(writer, obj);
        }
        catch (Throwable ex) {
            throw new MarshallerException("Failed to write field [id=" + this.colIdx + "]", ex);
        }
    }

    public void read(Row reader, Object obj) throws MarshallerException {
        try {
            this.read0(reader, obj);
        }
        catch (Throwable ex) {
            throw new MarshallerException("Failed to read field [id=" + this.colIdx + "]", ex);
        }
    }

    protected abstract void write0(RowAssembler var1, Object var2) throws Throwable;

    protected abstract void read0(Row var1, Object var2) throws Throwable;

    public Object columnValue(Row reader) throws MarshallerException {
        try {
            return this.readerHnd.invoke(reader, this.colIdx);
        }
        catch (Throwable ex) {
            throw new MarshallerException("Failed to read column [id=" + this.colIdx + "]", ex);
        }
    }

    Object value(Object obj) throws MarshallerException {
        try {
            return this.getterHnd.invoke(Objects.requireNonNull(obj));
        }
        catch (Throwable ex) {
            throw new MarshallerException("Failed to read field for column: [id=" + this.colIdx + "]", ex);
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            NULL_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendNull", new Class[0]));
            P_BYTE_READER = lookup.unreflect(Row.class.getMethod("byteValue", Integer.TYPE));
            P_SHORT_READER = lookup.unreflect(Row.class.getMethod("shortValue", Integer.TYPE));
            P_INT_READER = lookup.unreflect(Row.class.getMethod("intValue", Integer.TYPE));
            P_LONG_READER = lookup.unreflect(Row.class.getMethod("longValue", Integer.TYPE));
            P_FLOAT_READER = lookup.unreflect(Row.class.getMethod("floatValue", Integer.TYPE));
            P_DOUBLE_READER = lookup.unreflect(Row.class.getMethod("doubleValue", Integer.TYPE));
            BYTE_READER = lookup.unreflect(Row.class.getMethod("byteValueBoxed", Integer.TYPE));
            SHORT_READER = lookup.unreflect(Row.class.getMethod("shortValueBoxed", Integer.TYPE));
            INT_READER = lookup.unreflect(Row.class.getMethod("intValueBoxed", Integer.TYPE));
            LONG_READER = lookup.unreflect(Row.class.getMethod("longValueBoxed", Integer.TYPE));
            FLOAT_READER = lookup.unreflect(Row.class.getMethod("floatValueBoxed", Integer.TYPE));
            DOUBLE_READER = lookup.unreflect(Row.class.getMethod("doubleValueBoxed", Integer.TYPE));
            NUMBER_READER = lookup.unreflect(Row.class.getMethod("numberValue", Integer.TYPE));
            DECIMAL_READER = lookup.unreflect(Row.class.getMethod("decimalValue", Integer.TYPE));
            STRING_READER = lookup.unreflect(Row.class.getMethod("stringValue", Integer.TYPE));
            UUID_READER = lookup.unreflect(Row.class.getMethod("uuidValue", Integer.TYPE));
            BYTE_ARR_READER = lookup.unreflect(Row.class.getMethod("bytesValue", Integer.TYPE));
            BITSET_READER = lookup.unreflect(Row.class.getMethod("bitmaskValue", Integer.TYPE));
            DATE_READER = lookup.unreflect(Row.class.getMethod("dateValue", Integer.TYPE));
            TIME_READER = lookup.unreflect(Row.class.getMethod("timeValue", Integer.TYPE));
            TIMESTAMP_READER = lookup.unreflect(Row.class.getMethod("timestampValue", Integer.TYPE));
            DATETIME_READER = lookup.unreflect(Row.class.getMethod("dateTimeValue", Integer.TYPE));
            BYTE_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendByte", Byte.TYPE));
            SHORT_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendShort", Short.TYPE));
            INT_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendInt", Integer.TYPE));
            LONG_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendLong", Long.TYPE));
            FLOAT_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendFloat", Float.TYPE));
            DOUBLE_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendDouble", Double.TYPE));
            STRING_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendString", String.class));
            UUID_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendUuid", UUID.class));
            BYTE_ARR_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendBytes", byte[].class));
            BITSET_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendBitmask", BitSet.class));
            NUMBER_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendNumber", BigInteger.class));
            DECIMAL_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendDecimal", BigDecimal.class));
            DATE_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendDate", LocalDate.class));
            TIME_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendTime", LocalTime.class));
            TIMESTAMP_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendTimestamp", Instant.class));
            DATETIME_WRITER = lookup.unreflect(RowAssembler.class.getMethod("appendDateTime", LocalDateTime.class));
            TRANSFORM_AFTER_READ = lookup.unreflect(TypeConverter.class.getMethod("toObjectType", Object.class));
            TRANSFORM_BEFORE_WRITE = lookup.unreflect(TypeConverter.class.getMethod("toColumnType", Object.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class TransformingBinding
    extends ColumnBinding {
        private final MethodHandle afterReadHnd;
        private final MethodHandle beforeWriteHnd;

        TransformingBinding(int colIdx, MethodHandle getterMtd, MethodHandle setterMtd, MethodHandle readerHnd, MethodHandle writerHnd, TypeConverter<?, ?> interceptor) {
            super(colIdx, getterMtd, setterMtd, readerHnd, writerHnd);
            this.afterReadHnd = TRANSFORM_AFTER_READ.bindTo(interceptor);
            this.beforeWriteHnd = TRANSFORM_BEFORE_WRITE.bindTo(interceptor);
        }

        @Override
        protected void write0(RowAssembler writer, Object obj) throws Throwable {
            assert (obj != null);
            Object val = this.getterHnd.invoke(obj);
            if ((val = this.beforeWriteHnd.invoke(val)) == null) {
                NULL_WRITER.invoke(writer);
            } else {
                this.writerHnd.invoke(writer, val);
            }
        }

        @Override
        public void read0(Row reader, Object obj) throws Throwable {
            assert (obj != null);
            Object val = this.readerHnd.invoke(reader, this.colIdx);
            val = this.afterReadHnd.invoke(val);
            this.setterHnd.invoke(obj, val);
        }

        @Override
        public Object columnValue(Row reader) throws MarshallerException {
            try {
                Object val = this.readerHnd.invoke(reader, this.colIdx);
                return this.afterReadHnd.invoke(val);
            }
            catch (Throwable e) {
                throw new MarshallerException(e);
            }
        }
    }

    private static class PrimitiveFieldBinding
    extends ColumnBinding {
        PrimitiveFieldBinding(int colIdx, MethodHandle getterMtd, MethodHandle setterMtd, MethodHandle readerHnd, MethodHandle writerHnd) {
            super(colIdx, getterMtd, setterMtd, readerHnd, writerHnd);
        }

        @Override
        protected void write0(RowAssembler writer, Object obj) throws Throwable {
            assert (obj != null);
            this.writerHnd.invoke(writer, this.getterHnd.invoke(obj));
        }

        @Override
        public void read0(Row reader, Object obj) throws Throwable {
            assert (obj != null);
            this.setterHnd.invoke(obj, this.readerHnd.invoke(reader, this.colIdx));
        }
    }

    private static class DefaultBinding
    extends ColumnBinding {
        DefaultBinding(int colIdx, MethodHandle getterMtd, MethodHandle setterMtd, MethodHandle readerHnd, MethodHandle writerHnd) {
            super(colIdx, getterMtd, setterMtd, readerHnd, writerHnd);
        }

        @Override
        protected void write0(RowAssembler writer, Object obj) throws Throwable {
            if ((obj = this.getterHnd.invoke(obj)) == null) {
                NULL_WRITER.invoke(writer);
            } else {
                this.writerHnd.invoke(writer, obj);
            }
        }

        @Override
        public void read0(Row reader, Object obj) throws Throwable {
            this.setterHnd.invoke(obj, this.readerHnd.invoke(reader, this.colIdx));
        }
    }

    private static class UnmappedFieldBinding
    extends ColumnBinding {
        private final Column col;

        UnmappedFieldBinding(Column col) {
            super(col.schemaIndex(), null, null, null, null);
            this.col = col;
        }

        @Override
        protected void read0(Row reader, Object obj) {
        }

        @Override
        protected void write0(RowAssembler writer, Object obj) {
            RowAssembler.writeValue(writer, this.col, this.col.defaultValue());
        }

        @Override
        Object value(Object obj) {
            return this.col.defaultValue();
        }
    }
}

