/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.schema;

import org.apache.ignite.internal.schema.Column;
import org.apache.ignite.internal.schema.DecimalNativeType;
import org.apache.ignite.internal.schema.NativeType;
import org.apache.ignite.internal.schema.NativeTypeSpec;
import org.apache.ignite.internal.schema.SchemaDescriptor;

public class BinaryTupleSchema {
    private final Element[] elements;
    private final boolean hasNullables;

    private BinaryTupleSchema(Element[] elements, boolean hasNullables) {
        this.elements = elements;
        this.hasNullables = hasNullables;
    }

    public static BinaryTupleSchema create(Element[] elements) {
        return new BinaryTupleSchema((Element[])elements.clone(), BinaryTupleSchema.checkNullables(elements));
    }

    public static BinaryTupleSchema createRowSchema(SchemaDescriptor descriptor) {
        return BinaryTupleSchema.createSchema(descriptor, 0, descriptor.length());
    }

    public static BinaryTupleSchema createKeySchema(SchemaDescriptor descriptor) {
        return BinaryTupleSchema.createSchema(descriptor, 0, descriptor.keyColumns().length());
    }

    public static BinaryTupleSchema createValueSchema(SchemaDescriptor descriptor) {
        return BinaryTupleSchema.createSchema(descriptor, descriptor.keyColumns().length(), descriptor.length());
    }

    private static BinaryTupleSchema createSchema(SchemaDescriptor descriptor, int colBegin, int colEnd) {
        int numCols = colEnd - colBegin;
        Element[] elements = new Element[numCols];
        boolean hasNullables = false;
        for (int i = 0; i < numCols; ++i) {
            Column column = descriptor.column(colBegin + i);
            boolean nullable = column.nullable();
            elements[i] = new Element(column.type(), nullable);
            hasNullables |= nullable;
        }
        boolean fullSize = colBegin == 0 && (colEnd == descriptor.length() || colEnd == descriptor.keyColumns().length());
        return new DenseRowSchema(elements, hasNullables, colBegin, fullSize);
    }

    public static BinaryTupleSchema createSchema(SchemaDescriptor descriptor, int[] columns) {
        Element[] elements = new Element[columns.length];
        boolean hasNullables = false;
        for (int i = 0; i < columns.length; ++i) {
            Column column = descriptor.column(columns[i]);
            boolean nullable = column.nullable();
            elements[i] = new Element(column.type(), nullable);
            hasNullables |= nullable;
        }
        return new SparseRowSchema(elements, (int[])columns.clone(), hasNullables);
    }

    public int elementCount() {
        return this.elements.length;
    }

    public boolean hasNullableElements() {
        return this.hasNullables;
    }

    public Element element(int index) {
        return this.elements[index];
    }

    public int columnIndex(int index) {
        return -1;
    }

    public boolean convertible() {
        return false;
    }

    private static boolean checkNullables(Element[] elements) {
        for (Element element : elements) {
            if (!element.nullable) continue;
            return true;
        }
        return false;
    }

    private static final class SparseRowSchema
    extends BinaryTupleSchema {
        int[] columns;

        private SparseRowSchema(Element[] elements, int[] columns, boolean hasNullables) {
            super(elements, hasNullables);
            this.columns = columns;
        }

        @Override
        public int columnIndex(int index) {
            return this.columns[index];
        }
    }

    private static final class DenseRowSchema
    extends BinaryTupleSchema {
        int columnBase;
        boolean fullSize;

        private DenseRowSchema(Element[] elements, boolean hasNullables, int columnBase, boolean fullSize) {
            super(elements, hasNullables);
            this.columnBase = columnBase;
            this.fullSize = fullSize;
        }

        @Override
        public int columnIndex(int index) {
            return index - this.columnBase;
        }

        @Override
        public boolean convertible() {
            return this.fullSize;
        }
    }

    public static final class Element {
        final NativeTypeSpec typeSpec;
        final int decimalScale;
        final boolean nullable;

        public Element(NativeType type, boolean nullable) {
            this.typeSpec = type.spec();
            if (this.typeSpec == NativeTypeSpec.DECIMAL) {
                DecimalNativeType decimalType = (DecimalNativeType)type;
                this.decimalScale = decimalType.scale();
            } else {
                this.decimalScale = 0;
            }
            this.nullable = nullable;
        }

        public NativeTypeSpec typeSpec() {
            return this.typeSpec;
        }

        public int decimalScale() {
            return this.decimalScale;
        }

        public boolean nullable() {
            return this.nullable;
        }
    }
}

