/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.ignite.lang.IgniteException;
import org.jetbrains.annotations.NotNull;

public class Timestamp
implements Comparable<Timestamp>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long EPOCH = LocalDateTime.of(2021, 1, 1, 0, 0, 0).toInstant(ZoneOffset.UTC).toEpochMilli();
    public static final short MAX_CNT = Short.MAX_VALUE;
    private static long localTime;
    private static long cntr;
    private static long localNodeId;
    private final long timestamp;
    private final long nodeId;

    public Timestamp(long timestamp, long nodeId) {
        this.timestamp = timestamp;
        this.nodeId = nodeId;
    }

    public Timestamp(UUID txId) {
        this.timestamp = txId.getMostSignificantBits();
        this.nodeId = txId.getLeastSignificantBits();
    }

    @Override
    public int compareTo(@NotNull Timestamp other) {
        return this.timestamp < other.timestamp ? -1 : (this.timestamp > other.timestamp ? 1 : Long.compare(this.nodeId, other.nodeId));
    }

    public boolean beforeOrEquals(Timestamp that) {
        return this.compareTo(that) <= 0;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Timestamp)) {
            return false;
        }
        return this.compareTo((Timestamp)o) == 0;
    }

    public int hashCode() {
        long hilo = this.timestamp ^ this.nodeId;
        return (int)(hilo >> 32) ^ (int)hilo;
    }

    public static synchronized Timestamp nextVersion() {
        long timestamp = Clock.systemUTC().instant().toEpochMilli() - EPOCH;
        long newTime = Math.max(localTime, timestamp);
        if (newTime == localTime) {
            if ((cntr = cntr + 1L & 0xFFFFL) == 0L) {
                newTime = Timestamp.waitForNextMillisecond(newTime);
            }
        } else {
            cntr = 0L;
        }
        localTime = newTime;
        return new Timestamp(newTime << 16 | cntr, localNodeId);
    }

    public UUID toUuid() {
        return new UUID(this.timestamp, this.nodeId);
    }

    private static long waitForNextMillisecond(long lastTimestamp) {
        long timestamp;
        while ((timestamp = Clock.systemUTC().instant().toEpochMilli() - EPOCH) <= lastTimestamp) {
        }
        return timestamp;
    }

    public String toString() {
        return new UUID(this.timestamp, this.nodeId).toString();
    }

    private static long getLocalNodeId() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            NetworkInterface iface = NetworkInterface.getByInetAddress(localHost);
            byte[] bytes = null;
            if (iface != null) {
                bytes = iface.getHardwareAddress();
            }
            if (bytes == null) {
                bytes = new byte[8];
                ThreadLocalRandom.current().nextBytes(bytes);
            }
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.put(bytes);
            for (int i = bytes.length; i < 8; ++i) {
                buffer.put((byte)0);
            }
            buffer.flip();
            return buffer.getLong();
        }
        catch (Exception e) {
            throw new IgniteException("Failed to get local node id", (Throwable)e);
        }
    }

    static {
        localNodeId = Timestamp.getLocalNodeId();
    }
}

