/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest;

import io.micronaut.context.ApplicationContext;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.openapi.annotation.OpenAPIInclude;
import io.micronaut.runtime.Micronaut;
import io.micronaut.runtime.exceptions.ApplicationStartupException;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.info.License;
import java.net.BindException;
import java.util.List;
import java.util.Map;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.manager.IgniteComponent;
import org.apache.ignite.internal.rest.RestFactory;
import org.apache.ignite.internal.rest.api.cluster.ClusterManagementApi;
import org.apache.ignite.internal.rest.api.cluster.TopologyApi;
import org.apache.ignite.internal.rest.api.configuration.ClusterConfigurationApi;
import org.apache.ignite.internal.rest.api.configuration.NodeConfigurationApi;
import org.apache.ignite.internal.rest.api.metric.NodeMetricApi;
import org.apache.ignite.internal.rest.api.node.NodeManagementApi;
import org.apache.ignite.internal.rest.configuration.RestConfiguration;
import org.apache.ignite.internal.rest.configuration.RestView;
import org.apache.ignite.lang.IgniteInternalException;
import org.jetbrains.annotations.Nullable;

@OpenAPIDefinition(info=@Info(title="Ignite REST module", version="3.0.0-alpha", license=@License(name="Apache 2.0", url="https://ignite.apache.org"), contact=@Contact(email="user@ignite.apache.org")))
@OpenAPIInclude(classes={ClusterConfigurationApi.class, NodeConfigurationApi.class, ClusterManagementApi.class, NodeManagementApi.class, NodeMetricApi.class, TopologyApi.class})
public class RestComponent
implements IgniteComponent {
    public static final int DFLT_PORT = 10300;
    private static final String LOCALHOST = "localhost";
    private static final IgniteLogger LOG = Loggers.forClass(RestComponent.class);
    private final List<RestFactory> restFactories;
    private final RestConfiguration restConfiguration;
    private volatile ApplicationContext context;
    private int port;

    public RestComponent(List<RestFactory> restFactories, RestConfiguration restConfiguration) {
        this.restFactories = restFactories;
        this.restConfiguration = restConfiguration;
    }

    public void start() {
        RestView restConfigurationView = (RestView)this.restConfiguration.value();
        int desiredPort = restConfigurationView.port();
        int portRange = restConfigurationView.portRange();
        for (int portCandidate = desiredPort; portCandidate <= desiredPort + portRange; ++portCandidate) {
            try {
                this.port = portCandidate;
                this.context = this.buildMicronautContext(portCandidate).start();
                LOG.info("REST protocol started successfully", new Object[0]);
                return;
            }
            catch (ApplicationStartupException e) {
                BindException bindException = this.findBindException(e);
                if (bindException == null) {
                    throw new RuntimeException(e);
                }
                LOG.debug("Got exception during node start, going to try again [port={}]", new Object[]{portCandidate});
                continue;
            }
        }
        LOG.debug("Unable to start REST endpoint. All ports are in use [ports=[{}, {}]]", new Object[]{desiredPort, desiredPort + portRange});
        String msg = "Cannot start REST endpoint. All ports in range [" + desiredPort + ", " + (desiredPort + portRange) + "] are in use.";
        throw new RuntimeException(msg);
    }

    @Nullable
    private BindException findBindException(ApplicationStartupException e) {
        for (Throwable throwable = e.getCause(); throwable != null; throwable = throwable.getCause()) {
            if (!(throwable instanceof BindException)) continue;
            return (BindException)throwable;
        }
        return null;
    }

    private Micronaut buildMicronautContext(int portCandidate) {
        Micronaut micronaut = Micronaut.build((String[])new String[]{""});
        this.setFactories(micronaut);
        return micronaut.properties(Map.of("micronaut.server.port", portCandidate)).banner(false).mapError(ServerStartupException.class, this::mapServerStartupException).mapError(ApplicationStartupException.class, ex -> -1);
    }

    private void setFactories(Micronaut micronaut) {
        for (RestFactory factory : this.restFactories) {
            micronaut.singletons(new Object[]{factory});
        }
    }

    private int mapServerStartupException(ServerStartupException exception) {
        if (exception.getCause() instanceof BindException) {
            return -1;
        }
        return 1;
    }

    public synchronized void stop() throws Exception {
        if (this.context != null) {
            this.context.stop();
            this.context = null;
        }
    }

    public int port() {
        if (this.context == null) {
            throw new IgniteInternalException("RestComponent has not been started");
        }
        return this.port;
    }

    public String host() {
        if (this.context == null) {
            throw new IgniteInternalException("RestComponent has not been started");
        }
        return LOCALHOST;
    }
}

