/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.api.cluster;

import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.api.cluster.ClusterNodeDto;

@Controller(value="/management/v1/cluster/topology")
@Tag(name="topology")
public interface TopologyApi {
    @Get(value="physical")
    @Operation(operationId="physical")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Physical topology returned"), @ApiResponse(responseCode="500", description="Internal error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/json"})
    public Collection<ClusterNodeDto> physicalTopology();

    @Get(value="logical")
    @Operation(operationId="logical")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Logical topology returned"), @ApiResponse(responseCode="404", description="Logical topology not found, it means that the cluster is not initialized", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))}), @ApiResponse(responseCode="500", description="Internal error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/json"})
    public CompletableFuture<Collection<ClusterNodeDto>> logicalTopology();
}

