/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.mv;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.pagememory.Storable;
import org.apache.ignite.internal.pagememory.io.AbstractDataPageIo;
import org.apache.ignite.internal.pagememory.io.IoVersions;
import org.apache.ignite.internal.storage.pagememory.mv.io.RowVersionDataIo;
import org.apache.ignite.internal.tostring.IgniteToStringExclude;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public final class RowVersion
implements Storable {
    private static final int NEXT_LINK_STORE_SIZE_BYTES = 6;
    private static final int VALUE_SIZE_STORE_SIZE_BYTES = 4;
    public static final int TIMESTAMP_OFFSET = 0;
    public static final int NEXT_LINK_OFFSET = 12;
    public static final int VALUE_SIZE_OFFSET = 18;
    public static final int VALUE_OFFSET = 22;
    private final int partitionId;
    private long link;
    @Nullable
    private final HybridTimestamp timestamp;
    private final long nextLink;
    private final int valueSize;
    @IgniteToStringExclude
    @Nullable
    private final ByteBuffer value;

    public RowVersion(int partitionId, long nextLink, ByteBuffer value) {
        this(partitionId, 0L, null, nextLink, value);
    }

    public RowVersion(int partitionId, HybridTimestamp commitTimestamp, long nextLink, ByteBuffer value) {
        this(partitionId, 0L, commitTimestamp, nextLink, value);
    }

    public RowVersion(int partitionId, long link, @Nullable HybridTimestamp timestamp, long nextLink, @Nullable ByteBuffer value) {
        this.partitionId = partitionId;
        this.link(link);
        this.timestamp = timestamp;
        this.nextLink = nextLink;
        this.valueSize = value == null ? -1 : value.limit();
        this.value = value;
    }

    @Nullable
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public long nextLink() {
        return this.nextLink;
    }

    public int valueSize() {
        return this.valueSize;
    }

    public ByteBuffer value() {
        return Objects.requireNonNull(this.value);
    }

    public boolean hasNextLink() {
        return this.nextLink != 0L;
    }

    boolean isTombstone() {
        return RowVersion.isTombstone(this.valueSize());
    }

    static boolean isTombstone(int valueSize) {
        return valueSize == 0;
    }

    static boolean isTombstone(byte[] valueBytes) {
        return RowVersion.isTombstone(valueBytes.length);
    }

    boolean isUncommitted() {
        return this.timestamp == null;
    }

    boolean isCommitted() {
        return this.timestamp != null;
    }

    public final void link(long link) {
        this.link = link;
    }

    public final long link() {
        return this.link;
    }

    public final int partition() {
        return this.partitionId;
    }

    public int size() {
        assert (this.value != null);
        return this.headerSize() + this.value.limit();
    }

    public int headerSize() {
        return 22;
    }

    public IoVersions<? extends AbstractDataPageIo<?>> ioVersions() {
        return RowVersionDataIo.VERSIONS;
    }

    public String toString() {
        return S.toString(RowVersion.class, (Object)this);
    }
}

