/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.internal.pagememory.PageMemory;
import org.apache.ignite.internal.pagememory.util.PageLockListener;
import org.apache.ignite.internal.pagememory.util.PageLockListenerNoOp;
import org.apache.ignite.internal.schema.configuration.TableConfiguration;
import org.apache.ignite.internal.schema.configuration.TableView;
import org.apache.ignite.internal.schema.configuration.TablesConfiguration;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.VolatilePageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.index.meta.IndexMetaTree;
import org.apache.ignite.internal.storage.pagememory.mv.VersionChainTree;
import org.apache.ignite.internal.storage.pagememory.mv.VolatilePageMemoryMvPartitionStorage;
import org.apache.ignite.lang.IgniteInternalCheckedException;

public class VolatilePageMemoryTableStorage
extends AbstractPageMemoryTableStorage {
    private final VolatilePageMemoryDataRegion dataRegion;

    public VolatilePageMemoryTableStorage(TableConfiguration tableCfg, TablesConfiguration tablesCfg, VolatilePageMemoryDataRegion dataRegion) {
        super(tableCfg, tablesCfg);
        this.dataRegion = dataRegion;
    }

    public VolatilePageMemoryDataRegion dataRegion() {
        return this.dataRegion;
    }

    @Override
    public VolatilePageMemoryMvPartitionStorage createMvPartitionStorage(int partitionId) throws StorageException {
        VersionChainTree versionChainTree = this.createVersionChainTree(partitionId, (TableView)this.tableCfg.value());
        IndexMetaTree indexMetaTree = this.createIndexMetaTree(partitionId, (TableView)this.tableCfg.value());
        return new VolatilePageMemoryMvPartitionStorage(this, this.tablesConfiguration, partitionId, versionChainTree, indexMetaTree);
    }

    private IndexMetaTree createIndexMetaTree(int partitionId, TableView tableCfgView) {
        int grpId = tableCfgView.tableId();
        long metaPageId = this.dataRegion.pageMemory().allocatePage(grpId, partitionId, (byte)2);
        try {
            return new IndexMetaTree(grpId, tableCfgView.name(), partitionId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, new AtomicLong(), metaPageId, this.dataRegion.reuseList(), true);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException((Throwable)e);
        }
    }

    public boolean isVolatile() {
        return true;
    }

    public void destroy() throws StorageException {
        this.stop();
    }

    VersionChainTree createVersionChainTree(int partId, TableView tableView) throws StorageException {
        int grpId = tableView.tableId();
        try {
            long metaPageId = this.dataRegion.pageMemory().allocatePage(grpId, partId, (byte)2);
            return new VersionChainTree(grpId, tableView.name(), partId, (PageMemory)this.dataRegion.pageMemory(), (PageLockListener)PageLockListenerNoOp.INSTANCE, new AtomicLong(), metaPageId, this.dataRegion.reuseList(), true);
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException(String.format("Error creating TableTree [tableName=%s, partitionId=%s]", tableView.name(), partId), (Throwable)e);
        }
    }
}

