/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.util.UUID;
import org.apache.ignite.lang.ErrorGroup;
import org.apache.ignite.lang.ErrorGroups;
import org.jetbrains.annotations.Nullable;

public class IgniteInternalException
extends RuntimeException {
    private static final long serialVersionUID = 0L;
    private final String groupName;
    private final int code;
    private final UUID traceId;

    public IgniteInternalException(int code) {
        this(UUID.randomUUID(), code);
    }

    public IgniteInternalException(UUID traceId, int code) {
        super(ErrorGroup.errorMessage(traceId, code, null));
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode(ErrorGroup.extractGroupCode(code)).name();
        this.code = code;
    }

    public IgniteInternalException(int code, String message) {
        this(UUID.randomUUID(), code, message);
    }

    public IgniteInternalException(UUID traceId, int code, String message) {
        super(ErrorGroup.errorMessage(traceId, code, message));
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode(ErrorGroup.extractGroupCode(code)).name();
        this.code = code;
    }

    public IgniteInternalException(int code, Throwable cause) {
        this(UUID.randomUUID(), code, cause);
    }

    public IgniteInternalException(UUID traceId, int code, Throwable cause) {
        super(ErrorGroup.errorMessageFromCause(traceId, code, cause), cause);
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode(ErrorGroup.extractGroupCode(code)).name();
        this.code = code;
    }

    public IgniteInternalException(int code, String message, Throwable cause) {
        this(UUID.randomUUID(), code, message, cause);
    }

    public IgniteInternalException(UUID traceId, int code, String message, Throwable cause) {
        super(ErrorGroup.errorMessage(traceId, code, message), cause);
        this.traceId = traceId;
        this.groupName = ErrorGroup.errorGroupByCode(ErrorGroup.extractGroupCode(code)).name();
        this.code = code;
    }

    @Deprecated
    public IgniteInternalException() {
        this(ErrorGroups.Common.UNKNOWN_ERR);
    }

    @Deprecated
    public IgniteInternalException(String msg) {
        this(ErrorGroups.Common.UNKNOWN_ERR, msg);
    }

    @Deprecated
    public IgniteInternalException(Throwable cause) {
        this(ErrorGroups.Common.UNKNOWN_ERR, cause);
    }

    @Deprecated
    public IgniteInternalException(String msg, @Nullable Throwable cause) {
        this(ErrorGroups.Common.UNKNOWN_ERR, msg, cause);
    }

    public String groupName() {
        return this.groupName;
    }

    public int code() {
        return this.code;
    }

    public String codeAsString() {
        return "IGN-" + this.groupName() + "-" + this.errorCode();
    }

    public int groupCode() {
        return ErrorGroup.extractGroupCode(this.code);
    }

    public int errorCode() {
        return ErrorGroup.extractErrorCode(this.code);
    }

    public UUID traceId() {
        return this.traceId;
    }
}

