/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.network.serialization.marshal;

import java.io.DataOutput;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.BitSet;
import org.apache.ignite.internal.network.serialization.ClassDescriptor;
import org.apache.ignite.internal.network.serialization.DeclaredType;
import org.apache.ignite.internal.network.serialization.FieldDescriptor;
import org.apache.ignite.internal.network.serialization.marshal.DefaultFieldsReaderWriter;
import org.apache.ignite.internal.network.serialization.marshal.LittleEndianBits;
import org.apache.ignite.internal.network.serialization.marshal.MarshalException;
import org.apache.ignite.internal.network.serialization.marshal.MarshallingContext;
import org.apache.ignite.internal.network.serialization.marshal.NullsBitsetWriter;
import org.apache.ignite.internal.network.serialization.marshal.StructuredObjectMarshaller;
import org.apache.ignite.internal.network.serialization.marshal.TypedValueWriter;
import org.apache.ignite.internal.network.serialization.marshal.UncheckedMarshalException;
import org.apache.ignite.internal.util.io.IgniteDataOutput;
import org.jetbrains.annotations.Nullable;

class UosObjectOutputStream
extends ObjectOutputStream {
    private final IgniteDataOutput output;
    private final TypedValueWriter valueWriter;
    private final TypedValueWriter unsharedWriter;
    private final DefaultFieldsReaderWriter defaultFieldsReaderWriter;
    private final MarshallingContext context;
    private UosPutField currentPut;

    UosObjectOutputStream(IgniteDataOutput output, TypedValueWriter valueWriter, TypedValueWriter unsharedWriter, DefaultFieldsReaderWriter defaultFieldsReaderWriter, MarshallingContext context) throws IOException {
        this.output = output;
        this.valueWriter = valueWriter;
        this.unsharedWriter = unsharedWriter;
        this.defaultFieldsReaderWriter = defaultFieldsReaderWriter;
        this.context = context;
    }

    @Override
    public void write(int val) throws IOException {
        this.output.write(val);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.output.write(buf);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.output.write(buf, off, len);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.output.writeByte(val);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.output.writeShort(val);
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.output.writeInt(val);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.output.writeLong(val);
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.output.writeFloat(val);
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.output.writeDouble(val);
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.output.writeChar(val);
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.output.writeBoolean(val);
    }

    @Override
    public void writeBytes(String str) throws IOException {
        this.output.writeBytes(str);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.output.writeChars(str);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.output.writeUTF(str);
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        this.doWriteObjectOfAnyType(obj);
    }

    private void doWriteObjectOfAnyType(Object obj) throws IOException {
        this.doWriteObject(obj, null);
    }

    private void doWriteObject(Object obj, DeclaredType declaredClass) throws IOException {
        try {
            this.valueWriter.write(obj, declaredClass, this.output, this.context);
        }
        catch (MarshalException e) {
            throw new UncheckedMarshalException("Cannot write an object", e);
        }
    }

    @Override
    public void writeUnshared(Object obj) throws IOException {
        this.doWriteUnshared(obj);
    }

    private void doWriteUnshared(Object obj) throws IOException {
        try {
            this.unsharedWriter.write(obj, null, this.output, this.context);
        }
        catch (MarshalException e) {
            throw new UncheckedMarshalException("Cannot write an unshared object", e);
        }
    }

    @Override
    public void defaultWriteObject() throws IOException {
        try {
            this.defaultFieldsReaderWriter.defaultWriteFields(this.context.objectCurrentlyWrittenWithWriteObject(), this.context.descriptorOfObjectCurrentlyWrittenWithWriteObject(), this.output, this.context);
        }
        catch (MarshalException e) {
            throw new UncheckedMarshalException("Cannot write fields in a default way", e);
        }
    }

    @Override
    public ObjectOutputStream.PutField putFields() {
        if (this.currentPut == null) {
            this.currentPut = new UosPutField(this.context.descriptorOfObjectCurrentlyWrittenWithWriteObject());
        }
        return this.currentPut;
    }

    @Override
    public void writeFields() throws IOException {
        if (this.currentPut == null) {
            throw new NotActiveException("no current PutField object");
        }
        this.currentPut.write(this);
    }

    @Override
    public void useProtocolVersion(int version) {
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("The correct way to reset is via MarshallingContext. Note that it's not valid to call this from writeObject()/readObject() implementation.");
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    UosPutField replaceCurrentPutFieldWithNull() {
        UosPutField oldPut = this.currentPut;
        this.currentPut = null;
        return oldPut;
    }

    void restoreCurrentPutFieldTo(UosPutField newPut) {
        this.currentPut = newPut;
    }

    int memoryBufferOffset() {
        return this.output.offset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeIntAtOffset(int offset, int value) throws IOException {
        int oldOffset = this.output.offset();
        try {
            this.output.offset(offset);
            this.output.writeInt(value);
        }
        finally {
            this.output.offset(oldOffset);
        }
    }

    private static class PutFieldNullsBitsetWriter
    extends NullsBitsetWriter {
        private final UosPutField putField;

        private PutFieldNullsBitsetWriter(UosPutField putField) {
            this.putField = putField;
        }

        @Override
        Object getFieldValue(Object target, FieldDescriptor fieldDescriptor) {
            return this.putField.objectFieldValue(fieldDescriptor.name());
        }
    }

    class UosPutField
    extends ObjectOutputStream.PutField {
        private final ClassDescriptor descriptor;
        private final byte[] primitiveFieldsData;
        private final Object[] objectFieldVals;
        private final NullsBitsetWriter nullsBitsetWriter = new PutFieldNullsBitsetWriter(this);

        private UosPutField(ClassDescriptor currentObjectDescriptor) {
            this.descriptor = currentObjectDescriptor;
            this.primitiveFieldsData = new byte[currentObjectDescriptor.primitiveFieldsDataSize()];
            this.objectFieldVals = new Object[currentObjectDescriptor.objectFieldsCount()];
        }

        @Override
        public void put(String name, boolean val) {
            LittleEndianBits.putBoolean(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Boolean.TYPE), val);
        }

        @Override
        public void put(String name, byte val) {
            this.primitiveFieldsData[this.primitiveFieldDataOffset((String)name, Byte.TYPE)] = val;
        }

        @Override
        public void put(String name, char val) {
            LittleEndianBits.putChar(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Character.TYPE), val);
        }

        @Override
        public void put(String name, short val) {
            LittleEndianBits.putShort(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Short.TYPE), val);
        }

        @Override
        public void put(String name, int val) {
            LittleEndianBits.putInt(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Integer.TYPE), val);
        }

        @Override
        public void put(String name, long val) {
            LittleEndianBits.putLong(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Long.TYPE), val);
        }

        @Override
        public void put(String name, float val) {
            LittleEndianBits.putFloat(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Float.TYPE), val);
        }

        @Override
        public void put(String name, double val) {
            LittleEndianBits.putDouble(this.primitiveFieldsData, this.primitiveFieldDataOffset(name, Double.TYPE), val);
        }

        @Override
        public void put(String name, Object val) {
            this.objectFieldVals[this.objectFieldIndex((String)name)] = val;
        }

        private int primitiveFieldDataOffset(String fieldName, Class<?> requiredType) {
            return this.descriptor.primitiveFieldDataOffset(fieldName, requiredType.getName());
        }

        private int objectFieldIndex(String fieldName) {
            return this.descriptor.objectFieldIndex(fieldName);
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            if (out != UosObjectOutputStream.this) {
                throw new IllegalArgumentException("This is not my output: " + out);
            }
            @Nullable BitSet nullsBitSet = this.nullsBitsetWriter.writeNullsBitSet(UosObjectOutputStream.this.context.objectCurrentlyWrittenWithWriteObject(), this.descriptor, (DataOutput)UosObjectOutputStream.this.output);
            int objectFieldIndex = 0;
            for (FieldDescriptor fieldDesc : this.descriptor.fields()) {
                objectFieldIndex = this.writeNext(fieldDesc, objectFieldIndex, out, nullsBitSet);
            }
        }

        private int writeNext(FieldDescriptor fieldDesc, int objectFieldIndex, ObjectOutput out, @Nullable BitSet nullsBitSet) throws IOException {
            if (fieldDesc.isPrimitive()) {
                this.writePrimitive(out, fieldDesc);
                return objectFieldIndex;
            }
            return this.writeObject(fieldDesc, objectFieldIndex, nullsBitSet);
        }

        private void writePrimitive(ObjectOutput out, FieldDescriptor fieldDesc) throws IOException {
            int offset = this.descriptor.primitiveFieldDataOffset(fieldDesc.name(), fieldDesc.typeName());
            int length = fieldDesc.primitiveWidthInBytes();
            out.write(this.primitiveFieldsData, offset, length);
        }

        private int writeObject(FieldDescriptor fieldDesc, int objectFieldIndex, @Nullable BitSet nullsBitSet) throws IOException {
            Object objectToWrite = this.objectFieldVals[objectFieldIndex];
            if (StructuredObjectMarshaller.cannotAvoidWritingNull(fieldDesc, this.descriptor, nullsBitSet)) {
                if (fieldDesc.isUnshared()) {
                    UosObjectOutputStream.this.doWriteUnshared(objectToWrite);
                } else {
                    UosObjectOutputStream.this.doWriteObject(objectToWrite, fieldDesc);
                }
            }
            return objectFieldIndex + 1;
        }

        private Object objectFieldValue(String fieldName) {
            return this.objectFieldVals[this.objectFieldIndex(fieldName)];
        }
    }
}

