/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.encryption;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.management.encryption.CacheGroupEncryptionTask;
import org.apache.ignite.internal.management.encryption.EncryptionCacheGroupArg;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class ReencryptionSuspendTask
extends CacheGroupEncryptionTask<Boolean> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<EncryptionCacheGroupArg, CacheGroupEncryptionTask.SingleFieldDto<Boolean>> job(EncryptionCacheGroupArg arg) {
        return new ReencryptionSuspendJob(arg, this.debug);
    }

    protected static class ReencryptionSuspendResumeJobResult
    extends CacheGroupEncryptionTask.SingleFieldDto<Boolean> {
        private static final long serialVersionUID = 0L;

        @Override
        protected void writeExternalData(ObjectOutput out) throws IOException {
            out.writeBoolean((Boolean)this.value());
        }

        @Override
        protected void readExternalData(byte ver, ObjectInput in) throws IOException, ClassNotFoundException {
            this.value(in.readBoolean());
        }
    }

    private static class ReencryptionSuspendJob
    extends CacheGroupEncryptionTask.ReencryptionBaseJob<Boolean> {
        private static final long serialVersionUID = 0L;

        protected ReencryptionSuspendJob(@Nullable EncryptionCacheGroupArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected CacheGroupEncryptionTask.SingleFieldDto<Boolean> run0(CacheGroupContext grp) throws IgniteCheckedException {
            return new ReencryptionSuspendResumeJobResult().value(this.ignite.context().encryption().suspendReencryption(grp.groupId()));
        }
    }
}

