/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.trait;

import java.util.List;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite.internal.processors.query.calcite.trait.DistributionFunction;
import org.apache.ignite.internal.processors.query.calcite.trait.DistributionTrait;
import org.apache.ignite.internal.processors.query.calcite.trait.DistributionTraitDef;
import org.apache.ignite.internal.processors.query.calcite.trait.IgniteDistribution;
import org.apache.ignite.internal.util.typedef.internal.CU;

public class IgniteDistributions {
    private static final IgniteDistribution BROADCAST = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.broadcast()));
    private static final IgniteDistribution SINGLETON = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.singleton()));
    private static final IgniteDistribution RANDOM = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.random()));
    private static final IgniteDistribution ANY = IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.any()));

    public static IgniteDistribution any() {
        return ANY;
    }

    public static IgniteDistribution random() {
        return RANDOM;
    }

    public static IgniteDistribution single() {
        return SINGLETON;
    }

    public static IgniteDistribution broadcast() {
        return BROADCAST;
    }

    public static IgniteDistribution affinity(int key, String cacheName, Object identity) {
        return IgniteDistributions.affinity(key, CU.cacheId((String)cacheName), identity);
    }

    public static IgniteDistribution affinity(int key, int cacheId, Object identity) {
        return IgniteDistributions.hash((List<Integer>)ImmutableIntList.of((int[])new int[]{key}), DistributionFunction.affinity(cacheId, identity));
    }

    public static IgniteDistribution affinity(ImmutableIntList keys, int cacheId, Object identity) {
        return IgniteDistributions.hash((List<Integer>)keys, DistributionFunction.affinity(cacheId, identity));
    }

    public static IgniteDistribution hash(List<Integer> keys) {
        return IgniteDistributions.canonize(new DistributionTrait(ImmutableIntList.copyOf(keys), DistributionFunction.hash()));
    }

    public static IgniteDistribution hash(List<Integer> keys, DistributionFunction function) {
        return IgniteDistributions.canonize(new DistributionTrait(ImmutableIntList.copyOf(keys), function));
    }

    public static IgniteDistribution correlated(CorrelationId corrId, IgniteDistribution target) {
        return IgniteDistributions.canonize(new DistributionTrait(DistributionFunction.correlated(corrId, target)));
    }

    private static IgniteDistribution canonize(IgniteDistribution distr) {
        return (IgniteDistribution)DistributionTraitDef.INSTANCE.canonize((RelTrait)distr);
    }
}

