/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.ignite.internal.processors.query.calcite.exec.ExecutionContext;
import org.apache.ignite.internal.processors.query.calcite.exec.RuntimeIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.SortedListRangeCursor;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndex;
import org.apache.ignite.internal.processors.query.calcite.exec.TreeIndexIterable;
import org.apache.ignite.internal.processors.query.calcite.exec.exp.RangeIterable;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.F;

public class RuntimeSortedIndex<Row>
implements RuntimeIndex<Row>,
TreeIndex<Row> {
    protected final ExecutionContext<Row> ectx;
    protected final Comparator<Row> comp;
    private final RelCollation collation;
    private final ArrayList<Row> rows = new ArrayList();

    public RuntimeSortedIndex(ExecutionContext<Row> ectx, RelCollation collation, Comparator<Row> comp) {
        this.ectx = ectx;
        this.comp = comp;
        assert (Objects.nonNull(collation));
        this.collation = collation;
    }

    @Override
    public void push(Row r) {
        assert (this.rows.isEmpty() || this.comp.compare(r, this.rows.get(this.rows.size() - 1)) >= 0) : "Not sorted input";
        this.rows.add(r);
    }

    @Override
    public void close() {
        this.rows.clear();
    }

    @Override
    public GridCursor<Row> find(Row lower, Row upper, boolean lowerInclude, boolean upperInclude) {
        int firstCol = (Integer)F.first((List)this.collation.getKeys());
        Object lowerBound = lower == null ? null : this.ectx.rowHandler().get(firstCol, lower);
        Object upperBound = upper == null ? null : this.ectx.rowHandler().get(firstCol, upper);
        Object lowerRow = lowerBound == null ? null : (Object)lower;
        Object upperRow = upperBound == null ? null : (Object)upper;
        return new SortedListRangeCursor<Object>((Comparator<Object>)this.comp, (List<Object>)this.rows, lowerRow, upperRow, lowerInclude, upperInclude);
    }

    public Iterable<Row> scan(ExecutionContext<Row> ectx, RelDataType rowType, RangeIterable<Row> ranges) {
        return new TreeIndexIterable<Row>(this, ranges);
    }
}

