/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.exec;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.eventstorage.DiscoveryEventListener;
import org.apache.ignite.internal.managers.eventstorage.GridEventStorageManager;
import org.apache.ignite.internal.processors.query.calcite.exec.MailboxRegistry;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Inbox;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Mailbox;
import org.apache.ignite.internal.processors.query.calcite.exec.rel.Outbox;
import org.apache.ignite.internal.processors.query.calcite.util.AbstractService;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class MailboxRegistryImpl
extends AbstractService
implements MailboxRegistry {
    private static final Predicate<Mailbox<?>> ALWAYS_TRUE = o -> true;
    private final Map<MailboxKey, Outbox<?>> locals = new ConcurrentHashMap();
    private final Map<MailboxKey, Inbox<?>> remotes = new ConcurrentHashMap();
    @GridToStringExclude
    private final DiscoveryEventListener discoLsnr = (e, c) -> this.onNodeLeft(e.eventNode().id());
    @GridToStringExclude
    private GridEventStorageManager evtMgr;

    public MailboxRegistryImpl(GridKernalContext ctx) {
        super(ctx);
    }

    @Override
    public void onStart(GridKernalContext ctx) {
        this.eventManager(ctx.event());
        this.init();
    }

    @Override
    public void init() {
        this.eventManager().addDiscoveryEventListener(this.discoLsnr, 12, new int[]{11});
    }

    @Override
    public void tearDown() {
        this.eventManager().removeDiscoveryEventListener(this.discoLsnr, new int[]{12, 11});
    }

    @Override
    public Inbox<?> register(Inbox<?> inbox) {
        Inbox<?> old = this.remotes.putIfAbsent(new MailboxKey(inbox.queryId(), inbox.exchangeId()), inbox);
        return old != null ? old : inbox;
    }

    @Override
    public void unregister(Inbox<?> inbox) {
        this.remotes.remove(new MailboxKey(inbox.queryId(), inbox.exchangeId()), inbox);
    }

    @Override
    public void register(Outbox<?> outbox) {
        Outbox<?> res = this.locals.put(new MailboxKey(outbox.queryId(), outbox.exchangeId()), outbox);
        assert (res == null) : res;
    }

    @Override
    public void unregister(Outbox<?> outbox) {
        this.locals.remove(new MailboxKey(outbox.queryId(), outbox.exchangeId()), outbox);
    }

    @Override
    public Outbox<?> outbox(UUID qryId, long exchangeId) {
        return this.locals.get(new MailboxKey(qryId, exchangeId));
    }

    @Override
    public Inbox<?> inbox(UUID qryId, long exchangeId) {
        return this.remotes.get(new MailboxKey(qryId, exchangeId));
    }

    @Override
    public Collection<Inbox<?>> inboxes(@Nullable UUID qryId, long fragmentId, long exchangeId) {
        return this.remotes.values().stream().filter(MailboxRegistryImpl.makeFilter(qryId, fragmentId, exchangeId)).collect(Collectors.toList());
    }

    @Override
    public Collection<Outbox<?>> outboxes(@Nullable UUID qryId, long fragmentId, long exchangeId) {
        return this.locals.values().stream().filter(MailboxRegistryImpl.makeFilter(qryId, fragmentId, exchangeId)).collect(Collectors.toList());
    }

    @Override
    public Collection<Inbox<?>> inboxes() {
        return Collections.unmodifiableCollection(this.remotes.values());
    }

    @Override
    public Collection<Outbox<?>> outboxes() {
        return Collections.unmodifiableCollection(this.locals.values());
    }

    public void eventManager(GridEventStorageManager evtMgr) {
        this.evtMgr = evtMgr;
    }

    public GridEventStorageManager eventManager() {
        return this.evtMgr;
    }

    private void onNodeLeft(UUID nodeId) {
        this.locals.values().forEach(n -> n.onNodeLeft(nodeId));
        this.remotes.values().forEach(n -> n.onNodeLeft(nodeId));
    }

    private static Predicate<Mailbox<?>> makeFilter(@Nullable UUID qryId, long fragmentId, long exchangeId) {
        Predicate<Mailbox<?>> filter = ALWAYS_TRUE;
        if (qryId != null) {
            filter = filter.and(mailbox -> Objects.equals(mailbox.queryId(), qryId));
        }
        if (fragmentId != -1L) {
            filter = filter.and(mailbox -> mailbox.fragmentId() == fragmentId);
        }
        if (exchangeId != -1L) {
            filter = filter.and(mailbox -> mailbox.exchangeId() == exchangeId);
        }
        return filter;
    }

    public String toString() {
        return S.toString(MailboxRegistryImpl.class, (Object)this);
    }

    private static class MailboxKey {
        private final UUID qryId;
        private final long exchangeId;

        private MailboxKey(UUID qryId, long exchangeId) {
            this.qryId = qryId;
            this.exchangeId = exchangeId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MailboxKey that = (MailboxKey)o;
            if (this.exchangeId != that.exchangeId) {
                return false;
            }
            return this.qryId.equals(that.qryId);
        }

        public int hashCode() {
            int res = this.qryId.hashCode();
            res = 31 * res + (int)(this.exchangeId ^ this.exchangeId >>> 32);
            return res;
        }

        public String toString() {
            return S.toString(MailboxKey.class, (Object)this);
        }
    }
}

