/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class GridMultiCollectionWrapper<E>
implements Collection<E> {
    public final Collection<E>[] collections;

    public GridMultiCollectionWrapper(Collection<E> ... collections) {
        this.collections = collections;
    }

    @Override
    public int size() {
        int size = 0;
        for (Collection<E> collection : this.collections) {
            size += collection.size();
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        for (Collection<E> collection : this.collections) {
            if (collection.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(Object o) {
        for (Collection<E> collection : this.collections) {
            if (!collection.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        if (this.collections.length == 0) {
            return Collections.emptyIterator();
        }
        return new Iterator<E>(){
            int currCol = 0;
            Iterator<E> currIter;
            {
                this.currIter = GridMultiCollectionWrapper.this.collections[0].iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.currIter.hasNext()) {
                    return true;
                }
                do {
                    ++this.currCol;
                    if (this.currCol >= GridMultiCollectionWrapper.this.collections.length) {
                        return false;
                    }
                    this.currIter = GridMultiCollectionWrapper.this.collections[this.currCol].iterator();
                } while (!this.currIter.hasNext());
                return true;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this.currIter.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        boolean rmv = false;
        for (Collection<E> collection : this.collections) {
            rmv |= collection.remove(o);
        }
        return rmv;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        boolean rmv = false;
        for (Collection<E> collection : this.collections) {
            rmv |= collection.removeAll(c);
        }
        return rmv;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        for (Collection<E> collection : this.collections) {
            collection.clear();
        }
    }

    public int collectionsSize() {
        return this.collections.length;
    }

    public Collection<E> innerCollection(int idx) {
        return this.collections[idx];
    }
}

