/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberExpression;
import org.apache.calcite.linq4j.tree.MethodDeclaration;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.IClassBodyEvaluator;
import org.codehaus.commons.compiler.ICompilerFactory;

public class JaninoRexCompiler
implements Interpreter.ScalarCompiler {
    private final RexBuilder rexBuilder;

    public JaninoRexCompiler(RexBuilder rexBuilder) {
        this.rexBuilder = rexBuilder;
    }

    @Override
    public Scalar.Producer compile(List<RexNode> nodes, RelDataType inputRowType) {
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, this.rexBuilder);
        for (RexNode node : nodes) {
            programBuilder.addProject(node, null);
        }
        RexProgram program = programBuilder.getProgram();
        BlockBuilder list = new BlockBuilder();
        BlockBuilder staticList = new BlockBuilder().withRemoveUnused(false);
        ParameterExpression context_ = Expressions.parameter(Context.class, (String)"context");
        ParameterExpression outputValues_ = Expressions.parameter(Object[].class, (String)"outputValues");
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl(this.rexBuilder.getTypeFactory().getTypeSystem());
        RexToLixTranslator.InputGetterImpl inputGetter = new RexToLixTranslator.InputGetterImpl((Expression)Expressions.field((Expression)context_, (Field)BuiltInMethod.CONTEXT_VALUES.field), PhysTypeImpl.of(javaTypeFactory, inputRowType, JavaRowFormat.ARRAY, false));
        Function1 correlates = a0 -> {
            throw new UnsupportedOperationException();
        };
        MemberExpression root = Expressions.field((Expression)context_, (Field)BuiltInMethod.CONTEXT_ROOT.field);
        SqlConformanceEnum conformance = SqlConformanceEnum.DEFAULT;
        List<Expression> expressionList = RexToLixTranslator.translateProjects(program, javaTypeFactory, conformance, list, staticList, null, (Expression)root, inputGetter, (Function1<String, RexToLixTranslator.InputGetter>)correlates);
        Ord.forEach(expressionList, (expression, i) -> list.add(Expressions.statement((Expression)Expressions.assign((Expression)Expressions.arrayIndex((Expression)outputValues_, (Expression)Expressions.constant((Object)i)), (Expression)expression))));
        return JaninoRexCompiler.baz(context_, outputValues_, list.toBlock(), staticList.toBlock().statements);
    }

    static Scalar.Producer baz(ParameterExpression context_, ParameterExpression outputValues_, BlockStatement block, List<Statement> declList) {
        ArrayList<MethodDeclaration> declarations = new ArrayList<MethodDeclaration>();
        ArrayList<MethodDeclaration> innerDeclarations = new ArrayList<MethodDeclaration>();
        ArrayList<Statement> statements = new ArrayList<Statement>(declList);
        statements.add((Statement)Expressions.return_(null, (Expression)Expressions.new_(Scalar.class, (Iterable)ImmutableList.of(), innerDeclarations)));
        declarations.add(Expressions.methodDecl((int)1, Scalar.class, (String)BuiltInMethod.FUNCTION_APPLY.method.getName(), (Iterable)ImmutableList.of((Object)DataContext.ROOT), (BlockStatement)Expressions.block(statements)));
        ParameterExpression objectRoot = Expressions.parameter(Object.class, (String)"root");
        declarations.add(Expressions.methodDecl((int)1, Object.class, (String)BuiltInMethod.FUNCTION_APPLY.method.getName(), (Iterable)ImmutableList.of((Object)objectRoot), (BlockStatement)Expressions.block((Statement[])new Statement[]{Expressions.return_(null, (Expression)Expressions.call((Expression)Expressions.parameter(Scalar.Producer.class, (String)"this"), (Method)BuiltInMethod.FUNCTION_APPLY.method, (Expression[])new Expression[]{Expressions.convert_((Expression)objectRoot, DataContext.class)}))})));
        innerDeclarations.add(Expressions.methodDecl((int)1, Void.TYPE, (String)BuiltInMethod.SCALAR_EXECUTE2.method.getName(), (Iterable)ImmutableList.of((Object)context_, (Object)outputValues_), (BlockStatement)block));
        BlockBuilder builder = new BlockBuilder();
        Expression values_ = builder.append("values", (Expression)Expressions.newArrayBounds(Object.class, (int)1, (Expression)Expressions.constant((Object)1)));
        builder.add(Expressions.statement((Expression)Expressions.call((Expression)Expressions.parameter(Scalar.class, (String)"this"), (Method)BuiltInMethod.SCALAR_EXECUTE2.method, (Expression[])new Expression[]{context_, values_})));
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.arrayIndex((Expression)values_, (Expression)Expressions.constant((Object)0))));
        innerDeclarations.add(Expressions.methodDecl((int)1, Object.class, (String)BuiltInMethod.SCALAR_EXECUTE1.method.getName(), (Iterable)ImmutableList.of((Object)context_), (BlockStatement)builder.toBlock()));
        ClassDeclaration classDeclaration = Expressions.classDecl((int)1, (String)"Buzz", null, (List)ImmutableList.of(Scalar.Producer.class), declarations);
        String s = Expressions.toString(declarations, (String)"\n", (boolean)false);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, s);
        }
        try {
            return JaninoRexCompiler.getScalar(classDeclaration, s);
        }
        catch (IOException | CompileException e) {
            throw new RuntimeException(e);
        }
    }

    static Scalar.Producer getScalar(ClassDeclaration expr, String s) throws CompileException, IOException {
        ICompilerFactory compilerFactory;
        ClassLoader classLoader = Objects.requireNonNull(JaninoRexCompiler.class.getClassLoader(), "classLoader");
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory((ClassLoader)classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        IClassBodyEvaluator cbe = compilerFactory.newClassBodyEvaluator();
        cbe.setClassName(expr.name);
        cbe.setImplementedInterfaces(new Class[]{Scalar.Producer.class});
        cbe.setParentClassLoader(classLoader);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            cbe.setDebuggingInformation(true, true, true);
        }
        return (Scalar.Producer)cbe.createInstance((Reader)new StringReader(s));
    }
}

