/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.ignite.internal.util.collection.BitSetIntSet;
import org.apache.ignite.internal.util.collection.IntSet;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;

public class ImmutableIntSet
implements IntSet {
    private static final ImmutableIntSet EMPTY_SET = new ImmutableIntSet(new BitSetIntSet(1));
    private final Set<Integer> delegate;

    public static ImmutableIntSet wrap(Set<Integer> delegate) {
        return delegate instanceof ImmutableIntSet ? (ImmutableIntSet)delegate : new ImmutableIntSet(delegate);
    }

    public static ImmutableIntSet emptySet() {
        return EMPTY_SET;
    }

    public ImmutableIntSet(Set<Integer> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean contains(int element) {
        if (this.delegate instanceof IntSet) {
            return ((IntSet)this.delegate).contains(element);
        }
        return this.delegate.contains(element);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.delegate.containsAll(coll);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public int[] toIntArray() {
        if (this.delegate instanceof IntSet) {
            return ((IntSet)this.delegate).toIntArray();
        }
        return U.toIntArray(this.delegate);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.delegate.equals(((ImmutableIntSet)o).delegate);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final Iterator<? extends Integer> iter;
            {
                this.iter = ImmutableIntSet.this.delegate.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Integer next() {
                return this.iter.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super Integer> act) {
                this.iter.forEachRemaining(act);
            }
        };
    }

    @Override
    public boolean add(int element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(int element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Integer integer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Integer> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(Consumer<? super Integer> act) {
        this.delegate.forEach(act);
    }

    @Override
    public boolean removeIf(Predicate<? super Integer> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<Integer> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public Stream<Integer> stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream<Integer> parallelStream() {
        return this.delegate.parallelStream();
    }
}

