/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.IncompleteObject;

public class IncompleteCacheObject
extends IncompleteObject<CacheObject> {
    public static final int HEAD_LEN = 5;
    private byte type;
    private int headOff;
    private byte[] head;

    public IncompleteCacheObject(ByteBuffer buf) {
        if (buf.remaining() >= 5) {
            this.data = new byte[buf.getInt()];
            this.type = buf.get();
        } else {
            this.head = new byte[5];
        }
    }

    @Override
    public void readData(ByteBuffer buf) {
        if (this.data == null) {
            assert (this.head != null);
            int len = Math.min(5 - this.headOff, buf.remaining());
            buf.get(this.head, this.headOff, len);
            this.headOff += len;
            if (this.headOff == 5) {
                ByteBuffer headBuf = ByteBuffer.wrap(this.head);
                headBuf.order(buf.order());
                this.data = new byte[headBuf.getInt()];
                this.type = headBuf.get();
            }
        }
        if (this.data != null) {
            super.readData(buf);
        }
    }

    public byte type() {
        return this.type;
    }
}

