/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.kubernetes.connection;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.kubernetes.configuration.KubernetesConnectionConfiguration;

public class KubernetesServiceAddressResolver {
    private URL url;
    private SSLContext ctx;
    private final KubernetesConnectionConfiguration cfg;
    private final AtomicBoolean initGuard = new AtomicBoolean();
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(){

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }};
    private final HostnameVerifier trustAllHosts = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession ses) {
            return true;
        }
    };

    public KubernetesServiceAddressResolver(KubernetesConnectionConfiguration cfg) {
        this.cfg = cfg;
    }

    public Collection<InetAddress> getServiceAddresses() {
        this.init();
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        try {
            HttpsURLConnection conn = (HttpsURLConnection)this.url.openConnection();
            conn.setHostnameVerifier(this.trustAllHosts);
            conn.setSSLSocketFactory(this.ctx.getSocketFactory());
            conn.addRequestProperty("Authorization", "Bearer " + this.serviceAccountToken(this.cfg.getAccountToken()));
            ObjectMapper mapper = new ObjectMapper();
            Endpoints endpoints = (Endpoints)mapper.readValue(conn.getInputStream(), Endpoints.class);
            if (endpoints != null && endpoints.subsets != null && !endpoints.subsets.isEmpty()) {
                for (Subset subset : endpoints.subsets) {
                    addrs.addAll(this.parseAddresses(subset.addresses));
                    if (!this.cfg.getIncludeNotReadyAddresses()) continue;
                    addrs.addAll(this.parseAddresses(subset.notReadyAddresses));
                }
            }
        }
        catch (Exception e) {
            throw new IgniteException("Failed to retrieve Ignite pods IP addresses.", (Throwable)e);
        }
        return addrs;
    }

    private void init() {
        this.cfg.verify();
        if (this.initGuard.compareAndSet(false, true)) {
            try {
                String path = String.format("/api/v1/namespaces/%s/endpoints/%s", this.cfg.getNamespace(), this.cfg.getServiceName());
                this.url = new URL(this.cfg.getMaster() + path);
                this.ctx = SSLContext.getInstance("SSL");
                this.ctx.init(null, this.trustAll, new SecureRandom());
            }
            catch (Exception e) {
                throw new IgniteException("Failed to connect to Ignite's Kubernetes Service.", (Throwable)e);
            }
            finally {
                this.initLatch.countDown();
            }
        }
        try {
            U.await((CountDownLatch)this.initLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteException("Thread has been interrupted.", (Throwable)e);
        }
        if (this.url == null || this.ctx == null) {
            throw new IgniteException("IP finder has not been initialized properly.");
        }
    }

    private Collection<InetAddress> parseAddresses(List<Address> addresses) {
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        if (addresses != null && !addresses.isEmpty()) {
            for (Address addr : addresses) {
                try {
                    addrs.add(InetAddress.getByName(addr.ip));
                }
                catch (UnknownHostException ignore) {
                    throw new IgniteException("Kubernetes Address is not valid IP address");
                }
            }
        }
        return addrs;
    }

    private String serviceAccountToken(String file) {
        try {
            return new String(Files.readAllBytes(Paths.get(file, new String[0])));
        }
        catch (IOException e) {
            throw new IgniteException("Failed to load services account token [setAccountToken= " + file + "]", (Throwable)e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Endpoints {
        public List<Subset> subsets;

        private Endpoints() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Subset {
        public List<Address> addresses;
        public List<Address> notReadyAddresses;

        private Subset() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Address {
        public String ip;

        private Address() {
        }
    }
}

