/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hop.pipeline.transforms.combinationlookup;

import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;
import org.junit.Before;
import org.junit.Test;

import java.sql.Connection;

import static org.mockito.Matchers.any;
import static org.mockito.Matchers.anyLong;
import static org.mockito.Mockito.*;

public class CombinationLookupTest {
  private DatabaseMeta databaseMeta;

  private TransformMeta transformMeta;

  private CombinationLookup combinationLookup;
  private CombinationLookupMeta combinationLookupMeta;
  private CombinationLookupData combinationLookupData;

  @Before
  public void setup() {
    databaseMeta = mock(DatabaseMeta.class);
    doReturn("").when(databaseMeta).quoteField(anyString());

    combinationLookupMeta = mock(CombinationLookupMeta.class);
    doReturn(databaseMeta).when(combinationLookupMeta).getDatabaseMeta();
    doReturn("sasas").when(combinationLookupMeta).getTechnicalKeyField();
    doReturn(new String[] {}).when(combinationLookupMeta).getKeyLookup();

    transformMeta = mock(TransformMeta.class);
    doReturn("transform").when(transformMeta).getName();
    doReturn(mock(TransformPartitioningMeta.class))
        .when(transformMeta)
        .getTargetTransformPartitioningMeta();
    doReturn(combinationLookupMeta).when(transformMeta).getTransform();

    Database db = mock(Database.class);
    doReturn(mock(Connection.class)).when(db).getConnection();

    combinationLookupData = mock(CombinationLookupData.class);
    combinationLookupData.db = db;
    combinationLookupData.keynrs = new int[] {};

    PipelineMeta pipelineMeta = mock(PipelineMeta.class);
    doReturn(transformMeta).when(pipelineMeta).findTransform(anyString());

    Pipeline pipeline = spy(new LocalPipelineEngine());
    combinationLookup =
        spy(
            new CombinationLookup(
                transformMeta,
                combinationLookupMeta,
                combinationLookupData,
                1,
                pipelineMeta,
                pipeline));
    doReturn(false).when(combinationLookup).isRowLevel();
    doReturn(true).when(combinationLookup).isAutoIncrement();
    doNothing().when(combinationLookup).logDetailed(anyString());
  }

  @Test
  public void testCombiInsert() throws Exception {
    combinationLookup.combiInsert(any(IRowMeta.class), any(Object[].class), anyLong(), anyLong());
    verify(databaseMeta, times(2)).supportsAutoGeneratedKeys();
  }
}
