/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.parse.ANTLRNoCaseStringStream;
import org.apache.hadoop.hive.ql.parse.HiveLexer;
import org.apache.hadoop.hive.ql.parse.HiveLexerStandard;
import org.apache.hadoop.hive.ql.parse.ParseError;
import org.apache.hadoop.hive.ql.parse.Quotation;

public abstract class GenericHiveLexer
extends Lexer {
    private final ArrayList<ParseError> errors = new ArrayList();
    private Configuration hiveConf;
    private Quotation quotation;

    public static GenericHiveLexer of(String statement, Configuration configuration) {
        GenericHiveLexer lexer = Quotation.from(configuration) == Quotation.STANDARD ? new HiveLexerStandard((CharStream)new ANTLRNoCaseStringStream(statement)) : new HiveLexer((CharStream)new ANTLRNoCaseStringStream(statement));
        lexer.setHiveConf(configuration);
        for (GenericHiveLexer wrappedLexers : lexer.getDelegates()) {
            wrappedLexers.setHiveConf(configuration);
        }
        return lexer;
    }

    public GenericHiveLexer() {
    }

    public GenericHiveLexer(CharStream input) {
        super(input);
    }

    public GenericHiveLexer(CharStream input, RecognizerSharedState state) {
        super(input, state);
    }

    public void setHiveConf(Configuration hiveConf) {
        this.hiveConf = hiveConf;
    }

    public abstract GenericHiveLexer[] getDelegates();

    protected Quotation allowQuotedId() {
        if (this.quotation == null) {
            this.quotation = Quotation.from(this.hiveConf);
        }
        return this.quotation;
    }

    public void displayRecognitionError(String[] tokenNames, RecognitionException e) {
        this.errors.add(new ParseError((BaseRecognizer)this, e, tokenNames));
    }

    public String getErrorMessage(RecognitionException e, String[] tokenNames) {
        Object msg = e instanceof NoViableAltException ? "character " + this.getCharErrorDisplay(e.c) + " not supported here" : super.getErrorMessage(e, tokenNames);
        return msg;
    }

    public ArrayList<ParseError> getErrors() {
        return this.errors;
    }
}

