/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.DatabaseProduct;
import org.apache.hadoop.hive.metastore.TransactionalMetaStoreEventListener;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.messaging.EventMessage;
import org.apache.hadoop.hive.metastore.metrics.Metrics;
import org.apache.hadoop.hive.metastore.txn.TxnErrorMsg;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.TxnStatus;
import org.apache.hadoop.hive.metastore.txn.entities.TxnWriteDetails;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionContext;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.functions.AbortTxnsFunction;
import org.apache.hadoop.hive.metastore.txn.jdbc.queries.GetWriteIdsMappingForTxnIdsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class PerformTimeoutsFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(PerformTimeoutsFunction.class);
    private static final String SELECT_TIMED_OUT_LOCKS_QUERY = "SELECT DISTINCT \"HL_LOCK_EXT_ID\" FROM \"HIVE_LOCKS\" WHERE \"HL_LAST_HEARTBEAT\" < %s - :timeout AND \"HL_TXNID\" = 0";
    public static int TIMED_OUT_TXN_ABORT_BATCH_SIZE = 50000;
    private final long timeout;
    private final long replicationTxnTimeout;
    private final List<TransactionalMetaStoreEventListener> transactionalListeners;

    public PerformTimeoutsFunction(long timeout, long replicationTxnTimeout, List<TransactionalMetaStoreEventListener> transactionalListeners) {
        this.timeout = timeout;
        this.replicationTxnTimeout = replicationTxnTimeout;
        this.transactionalListeners = transactionalListeners;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) {
        DatabaseProduct dbProduct = jdbcResource.getDatabaseProduct();
        try {
            this.timeOutLocks(jdbcResource, dbProduct);
            while (true) {
                Object s = " \"TXN_ID\", \"TXN_TYPE\" FROM \"TXNS\" WHERE \"TXN_STATE\" = " + String.valueOf((Object)TxnStatus.OPEN) + " AND (\"TXN_TYPE\" != " + TxnType.REPL_CREATED.getValue() + " AND \"TXN_LAST_HEARTBEAT\" <  " + TxnUtils.getEpochFn(dbProduct) + "-" + this.timeout + " OR  \"TXN_TYPE\" = " + TxnType.REPL_CREATED.getValue() + " AND \"TXN_LAST_HEARTBEAT\" <  " + TxnUtils.getEpochFn(dbProduct) + "-" + this.replicationTxnTimeout + ")";
                s = jdbcResource.getSqlGenerator().addLimitClause(10 * TIMED_OUT_TXN_ABORT_BATCH_SIZE, (String)s);
                LOG.debug("Going to execute query <{}>", s);
                List timedOutTxns = Objects.requireNonNull((List)jdbcResource.getJdbcTemplate().query((String)s, rs -> {
                    ArrayList txnbatch = new ArrayList();
                    HashMap<Long, TxnType> currentBatch = new HashMap<Long, TxnType>(TIMED_OUT_TXN_ABORT_BATCH_SIZE);
                    while (rs.next()) {
                        currentBatch.put(rs.getLong(1), TxnType.findByValue((int)rs.getInt(2)));
                        if (currentBatch.size() != TIMED_OUT_TXN_ABORT_BATCH_SIZE) continue;
                        txnbatch.add(currentBatch);
                        currentBatch = new HashMap(TIMED_OUT_TXN_ABORT_BATCH_SIZE);
                    }
                    if (!currentBatch.isEmpty()) {
                        txnbatch.add(currentBatch);
                    }
                    return txnbatch;
                }), "This never should be null, it's just to suppress warnings");
                if (timedOutTxns.isEmpty()) {
                    return null;
                }
                TransactionContext context = jdbcResource.getTransactionManager().getActiveTransaction();
                Object savePoint = context.createSavepoint();
                int numTxnsAborted = 0;
                for (Map batchToAbort : timedOutTxns) {
                    context.releaseSavepoint(savePoint);
                    savePoint = context.createSavepoint();
                    int abortedTxns = new AbortTxnsFunction(new ArrayList<Long>(batchToAbort.keySet()), true, false, false, TxnErrorMsg.ABORT_TIMEOUT).execute(jdbcResource);
                    if (abortedTxns == batchToAbort.size()) {
                        numTxnsAborted += batchToAbort.size();
                        LOG.info("Aborted the following transactions due to timeout: {}", (Object)batchToAbort);
                        if (this.transactionalListeners == null) continue;
                        List<TxnWriteDetails> txnWriteDetails = jdbcResource.execute(new GetWriteIdsMappingForTxnIdsHandler(batchToAbort.keySet()));
                        Map<Long, List<TxnWriteDetails>> txnWriteDetailsMap = txnWriteDetails.stream().collect(Collectors.groupingBy(TxnWriteDetails::getTxnId));
                        for (Map.Entry txnEntry : batchToAbort.entrySet()) {
                            TxnHandler.notifyCommitOrAbortEvent((Long)txnEntry.getKey(), EventMessage.EventType.ABORT_TXN, (TxnType)txnEntry.getValue(), jdbcResource.getConnection(), txnWriteDetailsMap.getOrDefault(txnEntry.getKey(), new ArrayList()), this.transactionalListeners);
                        }
                        LOG.debug("Added Notifications for the transactions that are aborted due to timeout: {}", (Object)batchToAbort);
                        continue;
                    }
                    context.rollbackToSavepoint(savePoint);
                }
                LOG.info("Aborted {} transaction(s) due to timeout", (Object)numTxnsAborted);
                if (!MetastoreConf.getBoolVar((Configuration)jdbcResource.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.METASTORE_ACIDMETRICS_EXT_ON)) continue;
                Metrics.getOrCreateCounter("total_num_timed_out_transactions").inc((long)numTxnsAborted);
            }
        }
        catch (Exception e) {
            LOG.warn("Aborting timed out transactions failed due to " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void timeOutLocks(MultiDataSourceJdbcResource jdbcResource, DatabaseProduct dbProduct) {
        try {
            TreeSet<Long> timedOutLockIds = new TreeSet<Long>(jdbcResource.getJdbcTemplate().query(String.format(SELECT_TIMED_OUT_LOCKS_QUERY, TxnUtils.getEpochFn(dbProduct)), (SqlParameterSource)new MapSqlParameterSource().addValue("timeout", (Object)this.timeout), (rs, rowNum) -> rs.getLong(1)));
            if (timedOutLockIds.isEmpty()) {
                LOG.debug("Did not find any timed-out locks, therefore retuning.");
                return;
            }
            ArrayList<String> queries = new ArrayList<String>();
            StringBuilder prefix = new StringBuilder();
            StringBuilder suffix = new StringBuilder();
            prefix.append("DELETE FROM \"HIVE_LOCKS\" WHERE \"HL_LAST_HEARTBEAT\" < ");
            prefix.append(TxnUtils.getEpochFn(dbProduct)).append("-").append(this.timeout);
            prefix.append(" AND \"HL_TXNID\" = 0 AND ");
            TxnUtils.buildQueryWithINClause(jdbcResource.getConf(), queries, prefix, suffix, timedOutLockIds, "\"HL_LOCK_EXT_ID\"", true, false);
            int deletedLocks = 0;
            for (String query : queries) {
                LOG.debug("Going to execute update: <{}>", (Object)query);
                deletedLocks += jdbcResource.getJdbcTemplate().update(query, (SqlParameterSource)new MapSqlParameterSource());
            }
            if (deletedLocks > 0) {
                LOG.info("Deleted {} locks due to timed-out. Lock ids: {}", (Object)deletedLocks, timedOutLockIds);
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to purge timed-out locks: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

