/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class OpenTxnEvent
extends ListenerEvent {
    private final List<Long> txnIds;
    private final TxnType txnType;

    public OpenTxnEvent(List<Long> txnIds, IHMSHandler handler) {
        this(txnIds, null, handler);
    }

    public OpenTxnEvent(List<Long> txnIds, TxnType txnType) {
        this(txnIds, txnType, null);
    }

    public OpenTxnEvent(List<Long> txnIds, TxnType txnType, IHMSHandler handler) {
        super(true, handler);
        this.txnIds = Lists.newArrayList(txnIds);
        this.txnType = txnType;
    }

    public List<Long> getTxnIds() {
        return this.txnIds;
    }

    public TxnType getTxnType() {
        return this.txnType;
    }
}

