/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.events.ListenerEvent;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AlterPartitionsEvent
extends ListenerEvent {
    private final List<Partition> old_parts;
    private final List<Partition> new_parts;
    private final Table table;
    private final boolean isTruncateOp;

    public AlterPartitionsEvent(List<Partition> old_parts, List<Partition> new_parts, Table table, boolean isTruncateOp, boolean status, IHMSHandler handler) {
        super(status, handler);
        this.old_parts = Objects.requireNonNull(old_parts, "old_parts is null");
        this.new_parts = Objects.requireNonNull(new_parts, "new_parts is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.isTruncateOp = isTruncateOp;
    }

    public Table getTable() {
        return this.table;
    }

    public Iterator<List<Partition>> getNewPartsIterator(int batchSize) {
        return this.iteratePartitions(this.new_parts, batchSize);
    }

    private Iterator<List<Partition>> iteratePartitions(List<Partition> partitions, final int batchSize) {
        HashMap writeIdToParts = new HashMap();
        partitions.forEach(part -> writeIdToParts.computeIfAbsent(part.getWriteId(), k -> new ArrayList()).add(part));
        final Iterator iterator = writeIdToParts.entrySet().iterator();
        return new Iterator<List<Partition>>(){
            Map.Entry<Long, List<Partition>> mapEntry;
            Iterator<Partition> current;

            @Override
            public boolean hasNext() {
                return iterator.hasNext() || this.current != null && this.current.hasNext();
            }

            @Override
            public List<Partition> next() {
                ArrayList<Partition> result = new ArrayList<Partition>();
                if (this.mapEntry == null && iterator.hasNext()) {
                    this.mapEntry = (Map.Entry)iterator.next();
                }
                if (this.current == null) {
                    this.current = this.mapEntry.getValue().iterator();
                } else if (!this.current.hasNext() && iterator.hasNext()) {
                    this.mapEntry = (Map.Entry)iterator.next();
                    this.current = this.mapEntry.getValue().iterator();
                }
                int i = 0;
                while (this.current != null && this.current.hasNext() && (batchSize <= 0 || i++ < batchSize)) {
                    result.add(this.current.next());
                }
                return result;
            }
        };
    }

    public Iterator<List<Partition>> getOldPartsIterator(int batchSize) {
        return this.iteratePartitions(this.old_parts, batchSize);
    }

    public boolean getIsTruncateOp() {
        return this.isTruncateOp;
    }
}

