/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.dataconnector.jdbc;

import org.apache.hadoop.hive.metastore.api.DataConnector;
import org.apache.hadoop.hive.metastore.dataconnector.jdbc.AbstractJDBCConnectorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveJDBCConnectorProvider
extends AbstractJDBCConnectorProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HiveJDBCConnectorProvider.class);
    private static final String DRIVER_CLASS = "org.apache.hive.jdbc.HiveDriver";
    protected static final String mappedType = "HIVE";

    public HiveJDBCConnectorProvider(String dbName, DataConnector dataConn) {
        super(dbName, dataConn, DRIVER_CLASS);
    }

    @Override
    protected String getCatalogName() {
        return null;
    }

    @Override
    protected String getDatabaseName() {
        return this.scoped_db;
    }

    @Override
    protected String getDataType(String dbDataType, int size) {
        String mappedType = super.getDataType(dbDataType, size);
        if (!mappedType.equalsIgnoreCase("void")) {
            return mappedType;
        }
        switch (dbDataType.trim().toLowerCase()) {
            case "string": 
            case "varchar": {
                mappedType = "string";
                break;
            }
            default: {
                mappedType = "void";
            }
        }
        return mappedType;
    }

    @Override
    protected String getDatasourceType() {
        return mappedType;
    }
}

