/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.wm;

import org.apache.hadoop.hive.ql.wm.CounterLimit;

public class CustomCounterLimit
implements CounterLimit {
    private String counterName;
    private long limit;

    CustomCounterLimit(String counterName, long limit) {
        this.counterName = counterName;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return this.counterName;
    }

    @Override
    public long getLimit() {
        return this.limit;
    }

    @Override
    public CounterLimit clone() {
        return new CustomCounterLimit(this.counterName, this.limit);
    }

    public String toString() {
        return "counter: " + this.counterName + " limit: " + this.limit;
    }

    public int hashCode() {
        int hash = 31 * this.counterName.hashCode();
        hash = (int)((long)hash + 31L * this.limit);
        return 31 * hash;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof CustomCounterLimit)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        CustomCounterLimit otherVcl = (CustomCounterLimit)other;
        return this.counterName.equalsIgnoreCase(otherVcl.counterName) && this.limit == otherVcl.limit;
    }
}

