/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimator;
import org.apache.hadoop.hive.common.ndv.NumDistinctValueEstimatorFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;

@Description(name="ndv_compute_bit_vector", value="_FUNC_(x) - Extracts NDV from bit vector.")
public class GenericUDFNDVComputeBitVector
extends GenericUDF {
    protected transient BinaryObjectInspector inputOI;
    protected final LongWritable result = new LongWritable(0L);

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "ndv_compute_bitvector input only takes primitive types, got " + arguments[0].getTypeName());
        }
        PrimitiveObjectInspector objectInspector = (PrimitiveObjectInspector)arguments[0];
        if (objectInspector.getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.BINARY) {
            throw new UDFArgumentTypeException(0, "ndv_compute_bitvector input only takes BINARY type, got " + arguments[0].getTypeName());
        }
        this.inputOI = (BinaryObjectInspector)arguments[0];
        return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (arguments[0] == null) {
            return null;
        }
        Object input = arguments[0].get();
        if (input == null) {
            return null;
        }
        byte[] buf = this.inputOI.getPrimitiveJavaObject(input);
        if (buf == null || buf.length == 0) {
            return null;
        }
        NumDistinctValueEstimator numDV = NumDistinctValueEstimatorFactory.getNumDistinctValueEstimator((byte[])buf);
        this.result.set(numDV.estimateNumDistinctValues());
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("ndv_compute_bit_vector", children, ",");
    }
}

