/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@Description(name="instr", value="_FUNC_(str, substr[, pos[, occurrence]]) - Returns the index of the given occurrence of substr in str after position pos", extended="pos is a 1-based index. If pos < 0, the starting position is\ndetermined by counting backwards from the end of str and then Hive\nsearches backward from the resulting position.\noccurrence is also a 1-based index. The value must be positive.\nIf occurrence is greater than the number of matching occurrences,\nthe function returns 0.\nIf either of the optional arguments, pos or occurrence, is NULL,\nthe function also returns NULL.\nExample:\n  > SELECT _FUNC_('Facebook', 'boo') FROM src LIMIT 1;\n  5\n  > SELECT _FUNC_('CORPORATE FLOOR','OR', 3, 2) FROM src LIMIT 1;\n  14\n  > SELECT _FUNC_('CORPORATE FLOOR','OR', -3, 2) FROM src LIMIT 1;\n  2")
public class GenericUDFInstr
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter[] converters;
    private transient PrimitiveObjectInspector.PrimitiveCategory[] inputTypes;
    private transient Integer posConst;
    private transient boolean isPosConst = false;
    private transient Integer occurrenceConst;
    private transient boolean isOccurrenceConst = false;
    IntWritable intWritable = new IntWritable(0);

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        this.checkArgsSize(arguments, 2, 4);
        this.converters = new ObjectInspectorConverters.Converter[arguments.length];
        this.inputTypes = new PrimitiveObjectInspector.PrimitiveCategory[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            this.checkArgPrimitive(arguments, i);
            if (i < 2) {
                this.obtainStringConverter(arguments, i, this.inputTypes, this.converters);
                continue;
            }
            this.obtainIntConverter(arguments, i, this.inputTypes, this.converters);
        }
        if (arguments.length > 2 && arguments[2] instanceof ConstantObjectInspector) {
            this.posConst = this.getConstantIntValue(arguments, 2);
            this.isPosConst = true;
        }
        if (arguments.length > 3 && arguments[3] instanceof ConstantObjectInspector) {
            this.occurrenceConst = this.getConstantIntValue(arguments, 3);
            this.isOccurrenceConst = true;
            if (this.occurrenceConst != null && this.occurrenceConst <= 0) {
                throw new UDFArgumentException("occurrence of function INSTR should be positive, got " + this.occurrenceConst);
            }
        }
        return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        int matchNum;
        if (arguments[0].get() == null || arguments[1].get() == null || this.isPosConst && this.posConst == null || this.isOccurrenceConst && this.occurrenceConst == null) {
            return null;
        }
        int pos = 1;
        if (this.isPosConst) {
            pos = this.posConst;
        } else if (arguments.length > 2) {
            IntWritable posWritable = (IntWritable)this.converters[2].convert(arguments[2].get());
            if (posWritable == null) {
                return null;
            }
            pos = posWritable.get();
            if (pos == 0) {
                this.intWritable.set(0);
                return this.intWritable;
            }
        }
        int occurrence = 1;
        if (this.isOccurrenceConst) {
            occurrence = this.occurrenceConst;
        } else if (arguments.length > 3) {
            IntWritable occurrenceWritable = (IntWritable)this.converters[3].convert(arguments[3].get());
            if (occurrenceWritable == null) {
                return null;
            }
            occurrence = occurrenceWritable.get();
            if (occurrence <= 0) {
                return null;
            }
        }
        Text text = (Text)this.converters[0].convert(arguments[0].get());
        Text subtext = (Text)this.converters[1].convert(arguments[1].get());
        String textString = text.toString();
        String subtextString = subtext.toString();
        int matchPos = -1;
        if (pos > 0) {
            int beg = pos - 1;
            for (matchNum = 0; matchNum < occurrence && beg < textString.length() && (matchPos = textString.indexOf(subtextString, beg)) != -1; ++matchNum) {
                beg = matchPos + 1;
            }
        } else {
            int beg = textString.length() + pos;
            for (matchNum = 0; matchNum < occurrence && beg >= 0 && (matchPos = textString.lastIndexOf(subtextString, beg)) != -1; ++matchNum) {
                beg = matchPos - 1;
            }
        }
        if (matchNum < occurrence) {
            matchPos = -1;
        }
        this.intWritable.set(matchPos + 1);
        return this.intWritable;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 2 && children.length <= 4);
        return this.getStandardDisplayString("instr", children);
    }
}

