/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDFArrayBase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="array_max", value="_FUNC_(array(obj1, obj2,...)) - The function returns the maximum value in array with elements for which order is supported", extended="Example:\n  > SELECT _FUNC_(array(1, 3, 0, NULL)) FROM src LIMIT 1;\n  3")
public class GenericUDFArrayMax
extends AbstractGenericUDFArrayBase {
    public GenericUDFArrayMax() {
        super("ARRAY_MAX", 1, 1, ObjectInspector.Category.PRIMITIVE);
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object array = arguments[0].get();
        if (this.arrayOI.getListLength(array) <= 0) {
            return null;
        }
        List retArray = ((ListObjectInspector)this.argumentOIs[0]).getList(array);
        Optional<Object> value = retArray.stream().filter(Objects::nonNull).max(Comparator.naturalOrder());
        return value.isPresent() ? value.get() : null;
    }
}

