/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCosDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncCosLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="cos", value="_FUNC_(x) - returns the cosine of x (x is in radians)", extended="Example:\n   > SELECT _FUNC_(0) FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={FuncCosDoubleToDouble.class, FuncCosLongToDouble.class})
public class UDFCos
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    protected DoubleWritable doEvaluate(DoubleWritable a) {
        this.result.set(StrictMath.cos(a.get()));
        return this.result;
    }
}

