/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.util.Comparator;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponseElement;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TableOptimizer {
    private static final String CLASS_NAME = TableOptimizer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);
    protected final HiveConf conf;
    protected final TxnStore txnHandler;
    protected final MetadataCache metadataCache;

    public abstract Set<CompactionInfo> findPotentialCompactions(long var1, ShowCompactResponse var3, Set<String> var4, Set<String> var5) throws MetaException;

    protected TableOptimizer(HiveConf conf, TxnStore txnHandler, MetadataCache metadataCache) {
        this.conf = conf;
        this.txnHandler = txnHandler;
        this.metadataCache = metadataCache;
    }

    protected boolean isEligibleForCompaction(CompactionInfo ci, ShowCompactResponse currentCompactions, Set<String> skipDBs, Set<String> skipTables) {
        try {
            if (skipDBs.contains(ci.dbname)) {
                LOG.info("Skipping {}::{}, skipDBs::size:{}", new Object[]{ci.dbname, ci.tableName, skipDBs.size()});
                return false;
            }
            if (this.replIsCompactionDisabledForDatabase(ci.dbname)) {
                skipDBs.add(ci.dbname);
                LOG.info("Skipping {} as compaction is disabled due to repl; skipDBs::size:{}", (Object)ci.dbname, (Object)skipDBs.size());
                return false;
            }
            String qualifiedTableName = ci.getFullTableName();
            if (skipTables.contains(qualifiedTableName)) {
                return false;
            }
            LOG.info("Checking to see if we should compact {}", (Object)ci.getFullPartitionName());
            if (this.foundCurrentOrFailedCompactions(currentCompactions, ci)) {
                return false;
            }
            Table t = this.metadataCache.computeIfAbsent(qualifiedTableName, () -> CompactorUtil.resolveTable(this.conf, ci.dbname, ci.tableName));
            if (t == null) {
                LOG.info("Can't find table {}, assuming it's a temp table or has been dropped and moving on.", (Object)qualifiedTableName);
                return false;
            }
            if (this.replIsCompactionDisabledForTable(t)) {
                skipTables.add(qualifiedTableName);
                return false;
            }
            Map dbParams = this.metadataCache.computeIfAbsent(ci.dbname, () -> this.resolveDatabase(ci)).getParameters();
            if (MetaStoreUtils.isNoAutoCompactSet((Map)dbParams, (Map)t.getParameters())) {
                if (Boolean.parseBoolean(MetaStoreUtils.getNoAutoCompact((Map)dbParams))) {
                    skipDBs.add(ci.dbname);
                    LOG.info("DB {} marked {}=true so we will not compact it.", (Object)"no_auto_compaction", (Object)ci.dbname);
                } else {
                    skipTables.add(qualifiedTableName);
                    LOG.info("Table {} marked {}=true so we will not compact it.", (Object)"no_auto_compaction", (Object)qualifiedTableName);
                }
                return false;
            }
        }
        catch (Exception e) {
            LOG.error("Caught exception while checking compaction eligibility.", (Throwable)e);
            try {
                ci.errorMessage = e.getMessage();
                this.txnHandler.markFailed(ci);
            }
            catch (MetaException ex) {
                LOG.error("Caught exception while marking compaction as failed.", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    private boolean replIsCompactionDisabledForTable(Table tbl) {
        boolean isCompactDisabled = ReplUtils.isFirstIncPending(tbl.getParameters());
        if (isCompactDisabled) {
            LOG.info("Compaction is disabled for table {}", (Object)tbl.getTableName());
        }
        return isCompactDisabled;
    }

    private boolean replIsCompactionDisabledForDatabase(String dbName) throws TException {
        try {
            Database database = HMSHandler.getMSForConf((Configuration)this.conf).getDatabase(MetaStoreUtils.getDefaultCatalog((Configuration)this.conf), dbName);
            boolean isReplCompactDisabled = ReplUtils.isFirstIncPending(database.getParameters());
            if (isReplCompactDisabled) {
                LOG.info("Compaction is disabled for database {}", (Object)dbName);
            }
            return isReplCompactDisabled;
        }
        catch (NoSuchObjectException e) {
            LOG.info("Unable to find database {}", (Object)dbName);
            return true;
        }
    }

    protected boolean foundCurrentOrFailedCompactions(ShowCompactResponse compactions, CompactionInfo ci) throws MetaException {
        boolean needsRetry;
        if (compactions.getCompacts() == null) {
            return false;
        }
        List<ShowCompactResponseElement> filteredElements = compactions.getCompacts().stream().filter(e -> e.getDbname().equals(ci.dbname) && e.getTablename().equals(ci.tableName) && (e.getPartitionname() == null && ci.partName == null || Objects.equals(e.getPartitionname(), ci.partName))).toList();
        if (filteredElements.stream().anyMatch(e -> "working".equals(e.getState()) || "initiated".equals(e.getState()))) {
            LOG.info("Found currently initiated or working compaction for {} so we will not initiate another compaction", (Object)ci.getFullPartitionName());
            return true;
        }
        int failedThreshold = MetastoreConf.getIntVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
        LongSummaryStatistics failedStats = filteredElements.stream().filter(e -> "succeeded".equals(e.getState()) || "failed".equals(e.getState())).sorted(Comparator.comparingLong(ShowCompactResponseElement::getId).reversed()).limit(failedThreshold).filter(e -> "failed".equals(e.getState())).collect(Collectors.summarizingLong(ShowCompactResponseElement::getEnqueueTime));
        long retryTime = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_RETRY_TIME, (TimeUnit)TimeUnit.MILLISECONDS);
        boolean bl = needsRetry = retryTime > 0L && failedStats.getMax() + retryTime < System.currentTimeMillis();
        if (failedStats.getCount() == (long)failedThreshold && !needsRetry) {
            LOG.warn("Will not initiate compaction for {} since last {} attempts to compact it failed.", (Object)ci.getFullPartitionName(), (Object)MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD);
            ci.errorMessage = "Compaction is not initiated since last " + String.valueOf(MetastoreConf.ConfVars.COMPACTOR_INITIATOR_FAILED_THRESHOLD) + " consecutive compaction attempts failed)";
            this.txnHandler.markFailed(ci);
            return true;
        }
        return false;
    }

    protected Database resolveDatabase(CompactionInfo ci) throws MetaException, NoSuchObjectException {
        return CompactorUtil.resolveDatabase(this.conf, ci.dbname);
    }
}

