/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CleanupRequest;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.MetadataCache;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSRemover {
    private static final Logger LOG = LoggerFactory.getLogger(FSRemover.class);
    private final HiveConf conf;
    private final ReplChangeManager replChangeManager;
    private final MetadataCache metadataCache;

    public FSRemover(HiveConf conf, ReplChangeManager replChangeManager, MetadataCache metadataCache) {
        this.conf = conf;
        this.replChangeManager = replChangeManager;
        this.metadataCache = metadataCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Path> clean(CleanupRequest cr) throws MetaException {
        Ref removedFiles = Ref.from(new ArrayList());
        try {
            Callable<List> cleanUpTask = () -> this.removeFiles(cr);
            if (CompactorUtil.runJobAsSelf(cr.runAs())) {
                removedFiles.value = cleanUpTask.call();
                return (List)removedFiles.value;
            }
            LOG.info("Cleaning as user {} for {}", (Object)cr.runAs(), (Object)cr.getFullPartitionName());
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)cr.runAs(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            try {
                ugi.doAs(() -> {
                    removedFiles.value = cleanUpTask.call();
                    return null;
                });
            }
            catch (Throwable throwable) {
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                    throw throwable;
                }
                catch (IOException exception) {
                    LOG.error("Could not clean up file-system handles for UGI: {} for {}", new Object[]{ugi, cr.getFullPartitionName(), exception});
                }
                throw throwable;
            }
            try {
                FileSystem.closeAllForUGI((UserGroupInformation)ugi);
                return (List)removedFiles.value;
            }
            catch (IOException exception) {
                LOG.error("Could not clean up file-system handles for UGI: {} for {}", new Object[]{ugi, cr.getFullPartitionName(), exception});
                return (List)removedFiles.value;
            }
        }
        catch (Exception ex) {
            LOG.error("Caught exception when cleaning, unable to complete cleaning of {} due to {}", (Object)cr, (Object)StringUtils.stringifyException((Throwable)ex));
        }
        return (List)removedFiles.value;
    }

    private List<Path> removeFiles(CleanupRequest cr) throws MetaException, IOException {
        boolean needCmRecycle;
        ArrayList<Path> deleted = new ArrayList<Path>();
        if (cr.getObsoleteDirs().isEmpty()) {
            return deleted;
        }
        LOG.info("About to remove {} obsolete directories from {}. {}", new Object[]{cr.getObsoleteDirs().size(), cr.getLocation(), CompactorUtil.getDebugInfo(cr.getObsoleteDirs())});
        try {
            Database db = this.metadataCache.computeIfAbsent(cr.getDbName(), () -> CompactorUtil.resolveDatabase(this.conf, cr.getDbName()));
            needCmRecycle = ReplChangeManager.isSourceOfReplication((Database)db);
        }
        catch (NoSuchObjectException ex) {
            needCmRecycle = false;
        }
        catch (RuntimeException ex) {
            if (ex.getCause() instanceof NoSuchObjectException) {
                needCmRecycle = false;
            }
            throw ex;
        }
        catch (Exception ex) {
            throw new MetaException(ex.getMessage());
        }
        FileSystem fs = new Path(cr.getLocation()).getFileSystem((Configuration)this.conf);
        for (Path dead : cr.getObsoleteDirs()) {
            LOG.debug("Going to delete path: {}", (Object)dead);
            if (needCmRecycle) {
                this.replChangeManager.recycle(dead, ReplChangeManager.RecycleType.MOVE, cr.isPurge());
            }
            if (!FileUtils.deleteDir((FileSystem)fs, (Path)dead, (boolean)cr.isPurge(), (Configuration)this.conf)) continue;
            deleted.add(dead);
        }
        return deleted;
    }
}

