/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.scheduled;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollRequest;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryPollResponse;
import org.apache.hadoop.hive.metastore.api.ScheduledQueryProgressInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.scheduled.IScheduledQueryMaintenanceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreBasedScheduledQueryService
implements IScheduledQueryMaintenanceService {
    private static final Logger LOG = LoggerFactory.getLogger(MetastoreBasedScheduledQueryService.class);
    private HiveConf conf;

    public MetastoreBasedScheduledQueryService(HiveConf conf) {
        this.conf = conf;
    }

    @Override
    public ScheduledQueryPollResponse scheduledQueryPoll() {
        try {
            ScheduledQueryPollRequest request = new ScheduledQueryPollRequest();
            request.setClusterNamespace(this.getClusterNamespace());
            ScheduledQueryPollResponse resp = this.getMSC().scheduledQueryPoll(request);
            return resp;
        }
        catch (Exception e) {
            LOG.error("Exception while polling scheduled queries", (Throwable)e);
            return null;
        }
    }

    @Override
    public void scheduledQueryProgress(ScheduledQueryProgressInfo info) {
        try {
            this.getMSC().scheduledQueryProgress(info);
        }
        catch (Exception e) {
            LOG.error("Exception while updating scheduled execution status of: " + info.getScheduledExecutionId(), (Throwable)e);
        }
    }

    private IMetaStoreClient getMSC() throws MetaException, HiveException {
        return Hive.get(this.conf).getMSC();
    }

    @Override
    public String getClusterNamespace() {
        return this.conf.getVar(HiveConf.ConfVars.HIVE_SCHEDULED_QUERIES_NAMESPACE);
    }
}

