/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalResolverCommonJoin
implements ConditionalResolver,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ConditionalResolverCommonJoin.class);

    @Override
    public List<Task<?>> getTasks(HiveConf conf, Object objCtx) {
        ConditionalResolverCommonJoinCtx ctx = ((ConditionalResolverCommonJoinCtx)objCtx).clone();
        ArrayList resTsks = new ArrayList();
        Task<?> task = this.resolveDriverAlias(ctx, conf);
        if (task == null) {
            resTsks.add(ctx.getCommonJoinTask());
        } else {
            if (task.getBackupTask() != null) {
                task.getBackupTask().setTaskTag(6);
            }
            resTsks.add(task);
        }
        return resTsks;
    }

    private Task<?> resolveDriverAlias(ConditionalResolverCommonJoinCtx ctx, HiveConf conf) {
        try {
            this.resolveUnknownSizes(ctx, conf);
            return this.resolveMapJoinTask(ctx, conf);
        }
        catch (Exception e) {
            LOG.info("Failed to resolve driver alias by exception.. Falling back to common join", (Throwable)e);
            return null;
        }
    }

    protected Task<?> resolveMapJoinTask(ConditionalResolverCommonJoinCtx ctx, HiveConf conf) throws Exception {
        Set<String> participants = this.getParticipants(ctx);
        Map<String, Long> aliasToKnownSize = ctx.getAliasToKnownSize();
        HashMap<Task<?>, Set<String>> taskToAliases = ctx.getTaskToAliases();
        long threshold = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SMALL_TABLES_FILESIZE);
        Long bigTableSize = null;
        Long smallTablesSize = null;
        Map.Entry nextTask = null;
        for (Map.Entry entry : taskToAliases.entrySet()) {
            Set aliases = (Set)entry.getValue();
            long sumOfOthers = Utilities.sumOfExcept(aliasToKnownSize, participants, aliases);
            if (sumOfOthers < 0L || sumOfOthers > threshold) continue;
            long aliasSize = Utilities.sumOf(aliasToKnownSize, aliases);
            if (bigTableSize != null && aliasSize <= bigTableSize) continue;
            nextTask = entry;
            bigTableSize = aliasSize;
            smallTablesSize = sumOfOthers;
        }
        if (nextTask != null) {
            LOG.info("Driver alias is " + String.valueOf(nextTask.getValue()) + " with size " + bigTableSize + " (total size of others : " + smallTablesSize + ", threshold : " + threshold + ")");
            return (Task)nextTask.getKey();
        }
        LOG.info("Failed to resolve driver alias (threshold : " + threshold + ", length mapping : " + String.valueOf(aliasToKnownSize) + ")");
        return null;
    }

    private Set<String> getParticipants(ConditionalResolverCommonJoinCtx ctx) {
        HashSet<String> participants = new HashSet<String>();
        for (List<String> aliases : ctx.getPathToAliases().values()) {
            participants.addAll(aliases);
        }
        return participants;
    }

    protected void resolveUnknownSizes(ConditionalResolverCommonJoinCtx ctx, HiveConf conf) throws Exception {
        Set<String> aliases = this.getParticipants(ctx);
        Map<String, Long> aliasToKnownSize = ctx.getAliasToKnownSize();
        Map<Path, List<String>> pathToAliases = ctx.getPathToAliases();
        HashSet<Path> unknownPaths = new HashSet<Path>();
        block0: for (Map.Entry<Path, List<String>> entry : pathToAliases.entrySet()) {
            for (String alias : entry.getValue()) {
                if (!aliases.contains(alias) || aliasToKnownSize.containsKey(alias)) continue;
                unknownPaths.add(entry.getKey());
                continue block0;
            }
        }
        Path hdfsTmpDir = ctx.getHdfsTmpDir();
        Path localTmpDir = ctx.getLocalTmpDir();
        for (Path path : unknownPaths) {
            if (!FileUtils.isPathWithinSubtree((Path)path, (Path)hdfsTmpDir) && !FileUtils.isPathWithinSubtree((Path)path, (Path)localTmpDir)) continue;
            FileSystem fs = path.getFileSystem((Configuration)conf);
            long fileSize = fs.getContentSummary(path).getLength();
            for (String alias : pathToAliases.get(path)) {
                Long length = aliasToKnownSize.get(alias);
                if (length != null) continue;
                aliasToKnownSize.put(alias, fileSize);
            }
        }
    }

    public static class ConditionalResolverCommonJoinCtx
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private HashMap<Task<?>, Set<String>> taskToAliases;
        Map<Path, List<String>> pathToAliases;
        Map<String, Long> aliasToKnownSize;
        private Task<?> commonJoinTask;
        private Path localTmpDir;
        private Path hdfsTmpDir;

        public HashMap<Task<?>, Set<String>> getTaskToAliases() {
            return this.taskToAliases;
        }

        public void setTaskToAliases(HashMap<Task<?>, Set<String>> taskToAliases) {
            this.taskToAliases = taskToAliases;
        }

        public Task<?> getCommonJoinTask() {
            return this.commonJoinTask;
        }

        public void setCommonJoinTask(Task<?> commonJoinTask) {
            this.commonJoinTask = commonJoinTask;
        }

        public Map<String, Long> getAliasToKnownSize() {
            return this.aliasToKnownSize == null ? (this.aliasToKnownSize = new HashMap<String, Long>()) : this.aliasToKnownSize;
        }

        public void setAliasToKnownSize(HashMap<String, Long> aliasToKnownSize) {
            this.aliasToKnownSize = aliasToKnownSize;
        }

        public Map<Path, List<String>> getPathToAliases() {
            return this.pathToAliases;
        }

        public void setPathToAliases(Map<Path, List<String>> pathToAliases) {
            this.pathToAliases = pathToAliases;
        }

        public Path getLocalTmpDir() {
            return this.localTmpDir;
        }

        public void setLocalTmpDir(Path localTmpDir) {
            this.localTmpDir = localTmpDir;
        }

        public Path getHdfsTmpDir() {
            return this.hdfsTmpDir;
        }

        public void setHdfsTmpDir(Path hdfsTmpDir) {
            this.hdfsTmpDir = hdfsTmpDir;
        }

        public ConditionalResolverCommonJoinCtx clone() {
            ConditionalResolverCommonJoinCtx ctx = new ConditionalResolverCommonJoinCtx();
            ctx.setTaskToAliases(this.taskToAliases);
            ctx.setCommonJoinTask(this.commonJoinTask);
            ctx.setPathToAliases(this.pathToAliases);
            ctx.setHdfsTmpDir(this.hdfsTmpDir);
            ctx.setLocalTmpDir(this.localTmpDir);
            ctx.setAliasToKnownSize(new HashMap<String, Long>(this.aliasToKnownSize));
            return ctx;
        }
    }
}

