/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.partition.rename.AlterTableRenamePartitionDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.repl.util.ReplUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;

public class RenamePartitionHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<?>> handle(MessageHandler.Context context) throws SemanticException {
        AlterPartitionMessage msg = this.deserializer.getAlterPartitionMessage(context.dmd.getPayload());
        String actualDbName = context.isDbNameEmpty() ? msg.getDB() : context.dbName;
        String actualTblName = msg.getTable();
        LinkedHashMap<String, String> newPartSpec = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> oldPartSpec = new LinkedHashMap<String, String>();
        TableName tableName = TableName.fromString((String)actualTblName, null, (String)actualDbName);
        ReplicationSpec replicationSpec = context.eventOnlyReplicationSpec();
        try {
            Iterator beforeIterator = msg.getPtnObjBefore().getValuesIterator();
            Iterator afterIterator = msg.getPtnObjAfter().getValuesIterator();
            Table tableObj = msg.getTableObj();
            for (FieldSchema fs : tableObj.getPartitionKeys()) {
                oldPartSpec.put(fs.getName(), (String)beforeIterator.next());
                newPartSpec.put(fs.getName(), (String)afterIterator.next());
            }
            AlterTableRenamePartitionDesc renamePtnDesc = new AlterTableRenamePartitionDesc(tableName, oldPartSpec, newPartSpec, replicationSpec, null);
            renamePtnDesc.setWriteId(msg.getWriteId());
            Task<DDLWork> renamePtnTask = TaskFactory.get(new DDLWork(this.readEntitySet, this.writeEntitySet, renamePtnDesc, true, context.getDumpDirectory(), context.getMetricCollector()), context.hiveConf);
            context.log.debug("Added rename ptn task : {}:{}->{}", new Object[]{renamePtnTask.getId(), oldPartSpec, newPartSpec});
            this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, newPartSpec);
            return ReplUtils.addChildTask(renamePtnTask);
        }
        catch (Exception e) {
            throw e instanceof SemanticException ? (SemanticException)((Object)e) : new SemanticException("Error reading message members", (Throwable)e);
        }
    }
}

