/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLDescWithTableProperties;
import org.apache.hadoop.hive.ql.ddl.DDLTask;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateMaterializedViewDesc;
import org.apache.hadoop.hive.ql.ddl.view.materialized.alter.rewrite.AlterMaterializedViewRewriteDesc;
import org.apache.hadoop.hive.ql.ddl.view.materialized.update.MaterializedViewUpdateDesc;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.NonBlockingOpDeDupProc;
import org.apache.hadoop.hive.ql.optimizer.SortedDynPartitionOptimizer;
import org.apache.hadoop.hive.ql.optimizer.correlation.ReduceSinkDeDuplication;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsAutoGatherContext;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.IStatsGatherDesc;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.BasicStatsNoJobTask;
import org.apache.hadoop.hive.serde2.DefaultFetchFormatter;
import org.apache.hadoop.hive.serde2.NoOpFetchFormatter;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftFormatter;
import org.apache.hadoop.hive.serde2.thrift.ThriftJDBCBinarySerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskCompiler {
    protected final Logger LOG = LoggerFactory.getLogger(TaskCompiler.class);
    protected Hive db;
    protected SessionState.LogHelper console;
    protected QueryState queryState;
    protected HiveConf conf;

    public void init(QueryState queryState, SessionState.LogHelper console, Hive db) {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.db = db;
        this.console = console;
    }

    /*
     * WARNING - void declaration
     */
    public void compile(ParseContext pCtx, List<Task<?>> rootTasks, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
        CreateTableDesc crtTblDesc;
        Context ctx = pCtx.getContext();
        GlobalLimitCtx globalLimitCtx = pCtx.getGlobalLimitCtx();
        ArrayList<Task<MoveWork>> mvTask = new ArrayList<Task<MoveWork>>();
        List<LoadTableDesc> loadTableWork = pCtx.getLoadTableWork();
        List<LoadFileDesc> loadFileWork = pCtx.getLoadFileWork();
        boolean isCStats = pCtx.getQueryProperties().isAnalyzeRewrite();
        int outerQueryLimit = pCtx.getQueryProperties().getOuterQueryLimit();
        boolean directInsert = false;
        if (pCtx.getCreateTable() != null && pCtx.getCreateTable().getStorageHandler() != null) {
            try {
                directInsert = HiveUtils.getStorageHandler((Configuration)this.conf, pCtx.getCreateTable().getStorageHandler()).directInsert();
            }
            catch (HiveException e) {
                throw new SemanticException("Failed to load storage handler:  " + e.getMessage());
            }
        }
        if (pCtx.getCreateViewDesc() != null && pCtx.getCreateViewDesc().getStorageHandler() != null) {
            try {
                directInsert = HiveUtils.getStorageHandler((Configuration)this.conf, pCtx.getCreateViewDesc().getStorageHandler()).directInsert();
            }
            catch (HiveException e) {
                throw new SemanticException("Failed to load storage handler:  " + e.getMessage());
            }
        }
        if (pCtx.getFetchTask() != null) {
            if (pCtx.getFetchTask().getTblDesc() == null) {
                return;
            }
            ((FetchWork)pCtx.getFetchTask().getWork()).setHiveServerQuery(SessionState.get().isHiveServerQuery());
            TableDesc resultTab = pCtx.getFetchTask().getTblDesc();
            if (!resultTab.getSerdeClassName().equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName())) {
                if (SessionState.get().isHiveServerQuery()) {
                    this.conf.set("list.sink.output.formatter", ThriftFormatter.class.getName());
                } else {
                    String string = this.conf.get("list.sink.output.formatter");
                    if (string == null || string.isEmpty()) {
                        this.conf.set("list.sink.output.formatter", DefaultFetchFormatter.class.getName());
                    }
                }
            }
            return;
        }
        if (!pCtx.getQueryProperties().isAnalyzeCommand()) {
            this.LOG.debug("Skipping optimize operator plan for analyze command.");
            this.optimizeOperatorPlan(pCtx);
        }
        if (pCtx.getQueryProperties().isQuery() && !isCStats) {
            void var16_53;
            void var17_66;
            if (!loadTableWork.isEmpty() || loadFileWork.size() != 1) {
                throw new SemanticException(ErrorMsg.INVALID_LOAD_TABLE_FILE_WORK.getMsg());
            }
            LoadFileDesc loadFileDesc = loadFileWork.get(0);
            String string = loadFileDesc.getColumns();
            String string2 = loadFileDesc.getColumnTypes();
            TableDesc tableDesc = pCtx.getFetchTableDesc();
            boolean bl = false;
            if (tableDesc == null) {
                Class<LazySimpleSerDe> serdeClass;
                String fileFormat;
                HiveConf.ResultFileFormat resultFileFormat = this.conf.getResultFileFormat();
                if (SessionState.get().getIsUsingThriftJDBCBinarySerDe() && resultFileFormat == HiveConf.ResultFileFormat.SEQUENCEFILE) {
                    fileFormat = resultFileFormat.toString();
                    serdeClass = ThriftJDBCBinarySerDe.class;
                    boolean bl2 = true;
                } else if (resultFileFormat == HiveConf.ResultFileFormat.SEQUENCEFILE) {
                    fileFormat = "HiveSequenceFile";
                    serdeClass = LazySimpleSerDe.class;
                } else {
                    fileFormat = resultFileFormat.toString();
                    serdeClass = LazySimpleSerDe.class;
                }
                TableDesc tableDesc2 = PlanUtils.getDefaultQueryOutputTableDesc(string, string2, fileFormat, serdeClass);
            } else {
                boolean bl3 = tableDesc.getProperties().getProperty("serialization.lib").equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName());
            }
            if (var17_66 != false) {
                this.conf.set("list.sink.output.formatter", NoOpFetchFormatter.class.getName());
            }
            FetchWork fetchWork = new FetchWork(loadFileDesc.getSourcePath(), (TableDesc)var16_53, outerQueryLimit);
            boolean isHiveServerQuery = SessionState.get().isHiveServerQuery();
            fetchWork.setHiveServerQuery(isHiveServerQuery);
            fetchWork.setSource(pCtx.getFetchSource());
            fetchWork.setSink(pCtx.getFetchSink());
            if (isHiveServerQuery && null != var16_53 && var16_53.getSerdeClassName().equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName()) && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS)) {
                fetchWork.setIsUsingThriftJDBCBinarySerDe(true);
            } else {
                fetchWork.setIsUsingThriftJDBCBinarySerDe(false);
            }
            ArrayList tableScanOps = Lists.newArrayList(pCtx.getTopOps().values());
            Set<FileSinkOperator> fsOps = OperatorUtils.findOperators(tableScanOps, FileSinkOperator.class);
            if (fsOps != null && fsOps.size() == 1) {
                FileSinkOperator op = fsOps.iterator().next();
                HashSet<FileStatus> filesToFetch = new HashSet<FileStatus>();
                ((FileSinkDesc)op.getConf()).setFilesToFetch(filesToFetch);
                fetchWork.setFilesToFetch(filesToFetch);
            }
            pCtx.setFetchTask((FetchTask)TaskFactory.get(fetchWork));
            int fetchLimit = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_LIMIT_OPT_MAX_FETCH);
            if (globalLimitCtx.isEnable() && globalLimitCtx.getGlobalLimit() > fetchLimit) {
                this.LOG.info("For FetchTask, LIMIT " + globalLimitCtx.getGlobalLimit() + " > " + fetchLimit + ". Doesn't qualify limit optimization.");
                globalLimitCtx.disableOpt();
            }
            if (outerQueryLimit == 0) {
                this.LOG.info("Limit 0. No query execution needed.");
                return;
            }
        } else if (!isCStats) {
            for (LoadTableDesc loadTableDesc : loadTableWork) {
                Task<MoveWork> task = TaskFactory.get(new MoveWork(pCtx.getQueryProperties().isCTAS() && pCtx.getCreateTable().isExternal(), null, null, loadTableDesc, null, false));
                mvTask.add(task);
            }
            boolean oneLoadFileForCtas = true;
            for (LoadFileDesc loadFileDesc : loadFileWork) {
                if (pCtx.getQueryProperties().isCTAS() || pCtx.getQueryProperties().isMaterializedView()) {
                    if (!oneLoadFileForCtas) {
                        throw new SemanticException("One query is not expected to contain multiple CTAS loads statements");
                    }
                    this.setLoadFileLocation(pCtx, loadFileDesc);
                    oneLoadFileForCtas = false;
                }
                mvTask.add(TaskFactory.get(new MoveWork(pCtx.getQueryProperties().isCTAS() && pCtx.getCreateTable().isExternal(), null, null, null, loadFileDesc, false)));
            }
        }
        this.generateTaskTree(rootTasks, pCtx, mvTask, inputs, outputs);
        for (Task<?> task : rootTasks) {
            GenMapRedUtils.setKeyAndValueDescForTaskTree(task);
        }
        for (Task<?> task : rootTasks) {
            this.setInputFormat(task);
        }
        if (directInsert) {
            if (pCtx.getCreateTable() != null) {
                crtTblDesc = pCtx.getCreateTable();
                crtTblDesc.validate(this.conf);
                Task<DDLWork> task = TaskFactory.get(new DDLWork(inputs, outputs, crtTblDesc));
                for (Task<?> task2 : rootTasks) {
                    task.addDependentTask(task2);
                    rootTasks.clear();
                    rootTasks.add(task);
                }
            } else if (pCtx.getCreateViewDesc() != null) {
                CreateMaterializedViewDesc createMaterializedViewDesc = pCtx.getCreateViewDesc();
                Task<DDLWork> task = TaskFactory.get(new DDLWork(inputs, outputs, createMaterializedViewDesc));
                MaterializedViewUpdateDesc materializedViewUpdateDesc = new MaterializedViewUpdateDesc(createMaterializedViewDesc.getViewName(), createMaterializedViewDesc.isRewriteEnabled(), false, false);
                Task<DDLWork> task3 = TaskFactory.get(new DDLWork(inputs, outputs, materializedViewUpdateDesc));
                task.addDependentTask(task3);
                for (Task<?> task4 : rootTasks) {
                    task3.addDependentTask(task4);
                    rootTasks.clear();
                    rootTasks.add(task);
                }
            }
        }
        this.optimizeTaskPlan(rootTasks, pCtx, ctx);
        if (isCStats || !pCtx.getColumnStatsAutoGatherContexts().isEmpty()) {
            LinkedHashMap<String, StatsTask> map = new LinkedHashMap<String, StatsTask>();
            if (isCStats) {
                if (rootTasks == null || rootTasks.size() != 1 || pCtx.getTopOps() == null || pCtx.getTopOps().size() != 1) {
                    throw new SemanticException("Can not find correct root task!");
                }
                try {
                    Task<StatsWork> task = rootTasks.iterator().next();
                    StatsTask statsTask = (StatsTask)this.genTableStats(pCtx, pCtx.getTopOps().values().iterator().next(), task, outputs);
                    task.addDependentTask(statsTask);
                    map.put(this.extractTableFullName(statsTask), statsTask);
                }
                catch (HiveException hiveException) {
                    throw new SemanticException((Throwable)hiveException);
                }
                this.genColumnStatsTask(pCtx.getAnalyzeRewrite(), loadFileWork, map, outerQueryLimit, 0);
            } else {
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                this.getLeafTasks(rootTasks, linkedHashSet);
                ArrayList<Task> arrayList = new ArrayList<Task>();
                for (Task task : linkedHashSet) {
                    if (task instanceof StatsTask) {
                        map.put(this.extractTableFullName((StatsTask)task), (StatsTask)task);
                        continue;
                    }
                    arrayList.add(task);
                }
                for (Task task : arrayList) {
                    for (Task cStatsTask : map.values()) {
                        task.addDependentTask(cStatsTask);
                    }
                }
                for (ColumnStatsAutoGatherContext columnStatsAutoGatherContext : pCtx.getColumnStatsAutoGatherContexts()) {
                    int n;
                    if (!columnStatsAutoGatherContext.isInsertInto()) {
                        this.genColumnStatsTask(columnStatsAutoGatherContext.getAnalyzeRewrite(), columnStatsAutoGatherContext.getLoadFileWork(), map, outerQueryLimit, 0);
                        continue;
                    }
                    try {
                        n = HiveStatsUtils.getNumBitVectorsForNDVEstimation((Configuration)this.conf);
                    }
                    catch (Exception e) {
                        throw new SemanticException(e.getMessage());
                    }
                    this.genColumnStatsTask(columnStatsAutoGatherContext.getAnalyzeRewrite(), columnStatsAutoGatherContext.getLoadFileWork(), map, outerQueryLimit, n);
                }
            }
        }
        this.decideExecMode(rootTasks, ctx, globalLimitCtx);
        if (pCtx.getQueryProperties().isCTAS() && !pCtx.getCreateTable().isMaterialization() && !directInsert) {
            crtTblDesc = pCtx.getCreateTable();
            crtTblDesc.validate(this.conf);
            Task<DDLWork> task = TaskFactory.get(new DDLWork(inputs, outputs, crtTblDesc));
            this.patchUpAfterCTASorMaterializedView(rootTasks, inputs, outputs, task, CollectionUtils.isEmpty(crtTblDesc.getPartColNames()));
        } else if (pCtx.getQueryProperties().isMaterializedView() && !directInsert) {
            CreateMaterializedViewDesc viewDesc = pCtx.getCreateViewDesc();
            Task<DDLWork> task = TaskFactory.get(new DDLWork(inputs, outputs, viewDesc));
            this.patchUpAfterCTASorMaterializedView(rootTasks, inputs, outputs, task, CollectionUtils.isEmpty(viewDesc.getPartColNames()));
        } else if (pCtx.getMaterializedViewUpdateDesc() != null) {
            MaterializedViewUpdateDesc materializedViewDesc = pCtx.getMaterializedViewUpdateDesc();
            DDLWork dDLWork = new DDLWork(inputs, outputs, materializedViewDesc);
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            this.getLeafTasks(rootTasks, linkedHashSet);
            Task<DDLWork> task = TaskFactory.get(dDLWork, this.conf);
            for (Task task5 : linkedHashSet) {
                task5.addDependentTask(task);
            }
        }
        if (globalLimitCtx.isEnable() && pCtx.getFetchTask() != null) {
            this.LOG.info("set least row check for FetchTask: " + globalLimitCtx.getGlobalLimit());
            ((FetchWork)pCtx.getFetchTask().getWork()).setLeastNumRows(globalLimitCtx.getGlobalLimit());
        }
        if (globalLimitCtx.isEnable() && globalLimitCtx.getLastReduceLimitDesc() != null) {
            this.LOG.info("set least row check for LimitDesc: " + globalLimitCtx.getGlobalLimit());
            globalLimitCtx.getLastReduceLimitDesc().setLeastRows(globalLimitCtx.getGlobalLimit());
        }
        Interner interner = Interners.newStrongInterner();
        GenMapRedUtils.finalMapWorkChores(rootTasks, (Configuration)pCtx.getConf(), (Interner<TableDesc>)interner);
    }

    private String extractTableFullName(StatsTask tsk) throws SemanticException {
        return ((StatsWork)tsk.getWork()).getFullTableName();
    }

    private Task<?> genTableStats(ParseContext parseContext, TableScanOperator tableScan, Task currentTask, Set<WriteEntity> outputs) throws HiveException {
        Class<? extends InputFormat> inputFormat = ((TableScanDesc)tableScan.getConf()).getTableMetadata().getInputFormatClass();
        Table table = ((TableScanDesc)tableScan.getConf()).getTableMetadata();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (table.isPartitioned()) {
            partitions.addAll(parseContext.getPrunedPartitions(tableScan).getPartitions());
            for (Partition partn : partitions) {
                this.LOG.trace("adding part: " + String.valueOf(partn));
                outputs.add(new WriteEntity(partn, WriteEntity.WriteType.DDL_NO_LOCK));
            }
        }
        BaseSemanticAnalyzer.TableSpec tableSpec = new BaseSemanticAnalyzer.TableSpec(table, partitions);
        ((TableScanDesc)tableScan.getConf()).getTableMetadata().setTableSpec(tableSpec);
        if (BasicStatsNoJobTask.canUseFooterScan(table, inputFormat)) {
            StatsWork columnStatsWork = new StatsWork(table, parseContext.getConf());
            columnStatsWork.setFooterScan();
            if (partitions.size() > 0) {
                columnStatsWork.addInputPartitions(parseContext.getPrunedPartitions(tableScan).getPartitions());
            }
            return TaskFactory.get(columnStatsWork);
        }
        BasicStatsWork statsWork = new BasicStatsWork(((TableScanDesc)tableScan.getConf()).getTableMetadata().getTableSpec());
        statsWork.setIsExplicitAnalyze(true);
        StatsWork columnStatsWork = new StatsWork(table, statsWork, parseContext.getConf());
        columnStatsWork.collectStatsFromAggregator((IStatsGatherDesc)tableScan.getConf());
        columnStatsWork.setSourceTask(currentTask);
        return TaskFactory.get(columnStatsWork);
    }

    private void setLoadFileLocation(ParseContext pCtx, LoadFileDesc lfd) throws SemanticException {
        Path location;
        DDLDescWithTableProperties ddlDesc = pCtx.getQueryProperties().isCTAS() ? pCtx.getCreateTable() : pCtx.getCreateViewDesc();
        FileSinkDesc dataSink = ddlDesc.getAndUnsetWriter();
        Long txnId = ddlDesc.getInitialWriteId();
        String loc = ddlDesc.getLocation();
        int stmtId = 0;
        Path path = location = loc == null ? this.getDefaultCtasOrCMVLocation(pCtx) : new Path(loc);
        if (pCtx.getQueryProperties().isCTAS()) {
            CreateTableDesc ctd = pCtx.getCreateTable();
            if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.CREATE_TABLE_AS_EXTERNAL)) {
                ctd.getTblProps().put("create_table_as_external", "true");
            }
            try {
                org.apache.hadoop.hive.metastore.api.Table tTable;
                Table table = ctd.toTable(this.conf);
                if (!ctd.isMaterialization()) {
                    table = this.db.getTranslateTableDryrun(table.getTTable());
                }
                if ((tTable = table.getTTable()).getSd() != null && tTable.getSd().getLocation() != null) {
                    location = new Path(tTable.getSd().getLocation());
                }
                ctd.getTblProps().remove("create_table_as_external");
                ctd.fromTable(tTable);
            }
            catch (HiveException ex) {
                throw new SemanticException((Throwable)ex);
            }
            pCtx.setCreateTable(ctd);
        }
        if (txnId != null) {
            dataSink.setDirName(location);
            location = new Path(location, AcidUtils.deltaSubdir(txnId, txnId, stmtId));
            lfd.setSourcePath(location);
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Setting MM CTAS to " + String.valueOf(location));
            }
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Location for LFD is being set to " + String.valueOf(location) + "; moving from " + String.valueOf(lfd.getSourcePath()));
        }
        lfd.setTargetDir(location);
    }

    private Path getDefaultCtasOrCMVLocation(ParseContext pCtx) throws SemanticException {
        try {
            boolean createTableOrMVUseSuffix;
            String protoName = null;
            String suffix = "";
            boolean isExternal = false;
            boolean bl = createTableOrMVUseSuffix = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX) || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED);
            if (pCtx.getQueryProperties().isCTAS()) {
                protoName = pCtx.getCreateTable().getDbTableName();
                isExternal = pCtx.getCreateTable().isExternal();
                suffix = Utilities.getTableOrMVSuffix(pCtx.getContext(), createTableOrMVUseSuffix &= AcidUtils.isTransactionalTable(pCtx.getCreateTable()));
            } else if (pCtx.getQueryProperties().isMaterializedView()) {
                protoName = pCtx.getCreateViewDesc().getViewName();
                suffix = Utilities.getTableOrMVSuffix(pCtx.getContext(), createTableOrMVUseSuffix &= AcidUtils.isTransactionalView(pCtx.getCreateViewDesc()));
            }
            String[] names = Utilities.getDbTableName(protoName);
            if (!this.db.databaseExists(names[0])) {
                throw new SemanticException("ERROR: The database " + names[0] + " does not exist.");
            }
            Warehouse wh = new Warehouse((Configuration)this.conf);
            return wh.getDefaultTablePath(this.db.getDatabase(names[0]), names[1] + suffix, isExternal);
        }
        catch (MetaException | HiveException e) {
            throw new SemanticException(e);
        }
    }

    private void patchUpAfterCTASorMaterializedView(List<Task<?>> rootTasks, Set<ReadEntity> inputs, Set<WriteEntity> outputs, Task<?> createTask, boolean createTaskAfterMoveTask) {
        Iterator<WriteEntity> outIter = outputs.iterator();
        block3: while (outIter.hasNext()) {
            switch (outIter.next().getType()) {
                case DFS_DIR: 
                case LOCAL_DIR: {
                    outIter.remove();
                    continue block3;
                }
            }
        }
        LinkedHashSet leaves = new LinkedHashSet();
        this.getLeafTasks(rootTasks, leaves);
        assert (leaves.size() > 0);
        Task targetTask = createTask;
        for (Task task : leaves) {
            if (task instanceof StatsTask) {
                for (Task<?> parentOfStatsTask : task.getParentTasks()) {
                    if (parentOfStatsTask instanceof MoveTask && !createTaskAfterMoveTask) {
                        this.interleaveTask(parentOfStatsTask, createTask);
                        continue;
                    }
                    parentOfStatsTask.addDependentTask(createTask);
                }
                for (Task<?> parentOfCrtTblTask : createTask.getParentTasks()) {
                    parentOfCrtTblTask.removeDependentTask(task);
                }
                createTask.addDependentTask(task);
                targetTask = task;
                continue;
            }
            if (task instanceof MoveTask && !createTaskAfterMoveTask) {
                this.interleaveTask(task, createTask);
                targetTask = task;
                continue;
            }
            task.addDependentTask(createTask);
        }
        if (createTask instanceof DDLTask) {
            DDLTask ddlTask = (DDLTask)createTask;
            DDLWork dDLWork = (DDLWork)ddlTask.getWork();
            DDLDesc desc = dDLWork.getDDLDesc();
            if (desc instanceof CreateMaterializedViewDesc) {
                CreateMaterializedViewDesc createViewDesc = (CreateMaterializedViewDesc)desc;
                String tableName = createViewDesc.getViewName();
                boolean retrieveAndInclude = createViewDesc.isRewriteEnabled();
                MaterializedViewUpdateDesc materializedViewUpdateDesc = new MaterializedViewUpdateDesc(tableName, retrieveAndInclude, false, false);
                DDLWork ddlWork = new DDLWork(inputs, outputs, materializedViewUpdateDesc);
                targetTask.addDependentTask(TaskFactory.get(ddlWork, this.conf));
            } else if (desc instanceof AlterMaterializedViewRewriteDesc) {
                AlterMaterializedViewRewriteDesc alterMVRewriteDesc = (AlterMaterializedViewRewriteDesc)desc;
                String tableName = alterMVRewriteDesc.getMaterializedViewName();
                boolean retrieveAndInclude = alterMVRewriteDesc.isRewriteEnable();
                boolean disableRewrite = !alterMVRewriteDesc.isRewriteEnable();
                MaterializedViewUpdateDesc materializedViewUpdateDesc = new MaterializedViewUpdateDesc(tableName, retrieveAndInclude, disableRewrite, false);
                DDLWork ddlWork = new DDLWork(inputs, outputs, materializedViewUpdateDesc);
                targetTask.addDependentTask(TaskFactory.get(ddlWork, this.conf));
            }
        }
    }

    private void interleaveTask(Task<?> dependentTask, Task<?> task) {
        for (Task<?> parentOfStatsTask : dependentTask.getParentTasks()) {
            parentOfStatsTask.addDependentTask(task);
        }
        for (Task<?> parentOfCrtTblTask : task.getParentTasks()) {
            parentOfCrtTblTask.removeDependentTask(dependentTask);
        }
        task.addDependentTask(dependentTask);
    }

    protected void genColumnStatsTask(BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite, List<LoadFileDesc> loadFileWork, Map<String, StatsTask> map, int outerQueryLimit, int numBitVector) throws SemanticException {
        String tableName = analyzeRewrite.getTableName();
        List<String> colName = analyzeRewrite.getColName();
        List<String> colType = analyzeRewrite.getColType();
        boolean isTblLevel = analyzeRewrite.isTblLvl();
        String cols = loadFileWork.get(0).getColumns();
        String colTypes = loadFileWork.get(0).getColumnTypes();
        TableDesc resultTab = SessionState.get().isHiveServerQuery() && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS) ? PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, HiveConf.ResultFileFormat.SEQUENCEFILE.toString(), ThriftJDBCBinarySerDe.class) : PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, this.conf.getResultFileFormat().toString(), LazySimpleSerDe.class);
        FetchWork fetch = new FetchWork(loadFileWork.get(0).getSourcePath(), resultTab, outerQueryLimit);
        ColumnStatsDesc cStatsDesc = new ColumnStatsDesc(tableName, colName, colType, isTblLevel, numBitVector, fetch);
        StatsTask columnStatsTask = map.get(tableName);
        if (columnStatsTask == null) {
            throw new SemanticException("Can not find " + tableName + " in genColumnStatsTask");
        }
        ((StatsWork)columnStatsTask.getWork()).setColStats(cStatsDesc);
    }

    private void getLeafTasks(List<Task<?>> rootTasks, Set<Task<?>> leaves) {
        for (Task<?> root : rootTasks) {
            this.getLeafTasks(root, leaves);
        }
    }

    private void getLeafTasks(Task<?> task, Set<Task<?>> leaves) {
        if (task.getDependentTasks() == null) {
            if (!leaves.contains(task)) {
                leaves.add(task);
            }
        } else {
            this.getLeafTasks(task.getDependentTasks(), leaves);
        }
    }

    protected abstract void decideExecMode(List<Task<?>> var1, Context var2, GlobalLimitCtx var3) throws SemanticException;

    protected void optimizeOperatorPlan(ParseContext pCtxSet) throws SemanticException {
    }

    protected abstract void optimizeTaskPlan(List<Task<?>> var1, ParseContext var2, Context var3) throws SemanticException;

    protected abstract void setInputFormat(Task<?> var1);

    protected abstract void generateTaskTree(List<Task<?>> var1, ParseContext var2, List<Task<MoveWork>> var3, Set<ReadEntity> var4, Set<WriteEntity> var5) throws SemanticException;

    protected void runDynPartitionSortOptimizations(ParseContext parseContext, HiveConf hConf) throws SemanticException {
        if (HiveConf.getBoolVar((Configuration)hConf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING) && HiveConf.getVar((Configuration)hConf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE).equals("nonstrict") && !HiveConf.getBoolVar((Configuration)hConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_LIST_BUCKETING)) {
            new SortedDynPartitionOptimizer().transform(parseContext);
            if (HiveConf.getBoolVar((Configuration)hConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_OPT_REDUCE_DEDUPLICATION)) {
                new ReduceSinkDeDuplication().transform(parseContext);
                new NonBlockingOpDeDupProc().transform(parseContext);
            }
        }
    }

    public ParseContext getParseContext(ParseContext pCtx, List<Task<?>> rootTasks) {
        ParseContext clone = new ParseContext(this.queryState, pCtx.getOpToPartPruner(), pCtx.getOpToPartList(), pCtx.getTopOps(), pCtx.getJoinOps(), pCtx.getSmbMapJoinOps(), pCtx.getLoadTableWork(), pCtx.getLoadFileWork(), pCtx.getColumnStatsAutoGatherContexts(), pCtx.getContext(), pCtx.getIdToTableNameMap(), pCtx.getDestTableId(), pCtx.getUCtx(), pCtx.getListMapJoinOpsNoReducer(), pCtx.getPrunedPartitions(), pCtx.getTabNameToTabObject(), pCtx.getOpToSamplePruner(), pCtx.getGlobalLimitCtx(), pCtx.getNameToSplitSample(), pCtx.getSemanticInputs(), rootTasks, pCtx.getOpToPartToSkewedPruner(), pCtx.getViewAliasToInput(), pCtx.getReduceSinkOperatorsAddedByEnforceBucketingSorting(), pCtx.getAnalyzeRewrite(), pCtx.getCreateTable(), pCtx.getCreateViewDesc(), pCtx.getMaterializedViewUpdateDesc(), pCtx.getQueryProperties(), pCtx.getViewProjectToTableSchema());
        clone.setFetchTask(pCtx.getFetchTask());
        clone.setLineageInfo(pCtx.getLineageInfo());
        clone.setMapJoinOps(pCtx.getMapJoinOps());
        clone.setRsToRuntimeValuesInfoMap(pCtx.getRsToRuntimeValuesInfoMap());
        clone.setRsToSemiJoinBranchInfo(pCtx.getRsToSemiJoinBranchInfo());
        clone.setColExprToGBMap(pCtx.getColExprToGBMap());
        clone.setSemiJoinHints(pCtx.getSemiJoinHints());
        return clone;
    }
}

