/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import java.util.Objects;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexTableInputRef;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRuleConfig;

public class HivePushdownSnapshotFilterRule
extends RelRule<Config> {
    public static final RelOptRule INSTANCE = new Config().withOperandSupplier(operandBuilder -> operandBuilder.operand(HiveFilter.class).anyInputs()).withDescription("HivePushdownSnapshotFilterRule").toRule();

    private HivePushdownSnapshotFilterRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        HiveFilter filter = (HiveFilter)call.rel(0);
        RexNode newCondition = (RexNode)filter.getCondition().accept((RexVisitor)new SnapshotIdShuttle(call.builder().getRexBuilder(), call.getMetadataQuery(), filter));
        call.transformTo(call.builder().push(filter.getInput()).filter(new RexNode[]{newCondition}).build());
    }

    static class SnapshotIdShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final RelMetadataQuery metadataQuery;
        private final RelNode startNode;

        public SnapshotIdShuttle(RexBuilder rexBuilder, RelMetadataQuery metadataQuery, RelNode startNode) {
            this.rexBuilder = rexBuilder;
            this.metadataQuery = metadataQuery;
            this.startNode = startNode;
        }

        public RexNode visitCall(RexCall call) {
            if (call.operands.size() == 2 && (this.setSnapShotId((RexNode)call.operands.get(0), (RexNode)call.operands.get(1)) || this.setSnapShotId((RexNode)call.operands.get(1), (RexNode)call.operands.get(0)))) {
                return this.rexBuilder.makeLiteral(true);
            }
            return super.visitCall(call);
        }

        private boolean setSnapShotId(RexNode op1, RexNode op2) {
            if (!op1.isA(SqlKind.LITERAL)) {
                return false;
            }
            RexLiteral literal = (RexLiteral)op1;
            if (literal.getTypeName() != SqlTypeName.DECIMAL) {
                return false;
            }
            Long snapshotId = (Long)literal.getValueAs(Long.class);
            RelOptTable relOptTable = this.getRelOptTableOf(op2);
            if (relOptTable == null) {
                return false;
            }
            RelOptHiveTable hiveTable = (RelOptHiveTable)relOptTable;
            hiveTable.getHiveTableMD().setVersionIntervalFrom(Objects.toString(snapshotId, null));
            return true;
        }

        private RelOptTable getRelOptTableOf(RexNode rexNode) {
            if (!(rexNode instanceof RexInputRef)) {
                return null;
            }
            RexInputRef rexInputRef = (RexInputRef)rexNode;
            Set rexNodeSet = this.metadataQuery.getExpressionLineage(this.startNode, (RexNode)rexInputRef);
            if (rexNodeSet == null || rexNodeSet.size() != 1) {
                return null;
            }
            RexNode resultRexNode = (RexNode)rexNodeSet.iterator().next();
            if (!(resultRexNode instanceof RexTableInputRef)) {
                return null;
            }
            RexTableInputRef tableInputRef = (RexTableInputRef)resultRexNode;
            RelOptTable relOptTable = tableInputRef.getTableRef().getTable();
            RelDataTypeField snapshotIdField = relOptTable.getRowType().getField(VirtualColumn.SNAPSHOT_ID.getName(), false, false);
            if (snapshotIdField == null) {
                return null;
            }
            return snapshotIdField.getIndex() == tableInputRef.getIndex() ? relOptTable : null;
        }
    }

    public static class Config
    extends HiveRuleConfig {
        public HivePushdownSnapshotFilterRule toRule() {
            return new HivePushdownSnapshotFilterRule(this);
        }
    }
}

