/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import java.util.Arrays;
import java.util.List;
import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnion;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUnionPushDownRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCUnionPushDownRule.class);
    public static final JDBCUnionPushDownRule INSTANCE = new JDBCUnionPushDownRule();

    public JDBCUnionPushDownRule() {
        super(JDBCUnionPushDownRule.operand(HiveUnion.class, (RelOptRuleOperand)JDBCUnionPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCUnionPushDownRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{JDBCUnionPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCUnionPushDownRule.any())}));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveUnion union = (HiveUnion)call.rel(0);
        HiveJdbcConverter converter1 = (HiveJdbcConverter)call.rel(1);
        HiveJdbcConverter converter2 = (HiveJdbcConverter)call.rel(2);
        if (!converter1.getJdbcConvention().getName().equals(converter2.getJdbcConvention().getName())) {
            return false;
        }
        if (!converter1.getConnectionUrl().equals(converter2.getConnectionUrl())) {
            return false;
        }
        if (!converter1.getConnectionUser().equals(converter2.getConnectionUser())) {
            return false;
        }
        return union.getInputs().size() == 2;
    }

    public void onMatch(RelOptRuleCall call) {
        LOG.debug("JDBCUnionPushDown has been called");
        HiveUnion union = (HiveUnion)call.rel(0);
        HiveJdbcConverter converter1 = (HiveJdbcConverter)call.rel(1);
        HiveJdbcConverter converter2 = (HiveJdbcConverter)call.rel(2);
        List<RelNode> unionInput = Arrays.asList(converter1.getInput(), converter2.getInput());
        JdbcRules.JdbcUnion jdbcUnion = new JdbcRules.JdbcUnion(union.getCluster(), union.getTraitSet().replace((RelTrait)converter1.getJdbcConvention()), unionInput, union.all);
        call.transformTo(converter1.copy(converter1.getTraitSet(), (RelNode)jdbcUnion));
    }
}

