/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import org.apache.calcite.adapter.jdbc.JdbcRules;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCRexCallValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCProjectPushDownRule
extends RelOptRule {
    private static final Logger LOG = LoggerFactory.getLogger(JDBCProjectPushDownRule.class);
    public static final JDBCProjectPushDownRule INSTANCE = new JDBCProjectPushDownRule();

    public JDBCProjectPushDownRule() {
        super(JDBCProjectPushDownRule.operand(HiveProject.class, (RelOptRuleOperand)JDBCProjectPushDownRule.operand(HiveJdbcConverter.class, (RelOptRuleOperandChildren)JDBCProjectPushDownRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        HiveProject project = (HiveProject)call.rel(0);
        HiveJdbcConverter conv = (HiveJdbcConverter)call.rel(1);
        for (RexNode currProject : project.getProjects()) {
            if (!JDBCRexCallValidator.isValidJdbcOperation(currProject, conv.getJdbcDialect())) {
                return false;
            }
            if (JDBCProjectPushDownRule.validDataType(conv.getJdbcDialect(), currProject)) continue;
            return false;
        }
        return true;
    }

    public void onMatch(RelOptRuleCall call) {
        LOG.debug("JDBCProjectPushDownRule has been called");
        HiveProject project = (HiveProject)call.rel(0);
        HiveJdbcConverter converter = (HiveJdbcConverter)call.rel(1);
        JdbcRules.JdbcProject jdbcProject = new JdbcRules.JdbcProject(project.getCluster(), project.getTraitSet().replace((RelTrait)converter.getJdbcConvention()), converter.getInput(), project.getProjects(), project.getRowType());
        call.transformTo(converter.copy(converter.getTraitSet(), (RelNode)jdbcProject));
    }

    private static boolean validDataType(SqlDialect dialect, RexNode e) {
        try {
            JdbcDataTypeValidatorVisitor visitor = new JdbcDataTypeValidatorVisitor(dialect);
            e.accept((RexVisitor)visitor);
            return true;
        }
        catch (Util.FoundOne ex) {
            Util.swallow((Throwable)ex, null);
            return false;
        }
    }

    private static final class JdbcDataTypeValidatorVisitor
    extends RexVisitorImpl<Void> {
        private final SqlDialect dialect;

        private JdbcDataTypeValidatorVisitor(SqlDialect dialect) {
            super(true);
            this.dialect = dialect;
        }

        public Void visitInputRef(RexInputRef inputRef) {
            if (!this.dialect.supportsDataType(inputRef.getType())) {
                throw Util.FoundOne.NULL;
            }
            return (Void)super.visitInputRef(inputRef);
        }

        public Void visitLocalRef(RexLocalRef localRef) {
            if (!this.dialect.supportsDataType(localRef.getType())) {
                throw Util.FoundOne.NULL;
            }
            return (Void)super.visitLocalRef(localRef);
        }

        public Void visitLiteral(RexLiteral literal) {
            if (!this.dialect.supportsDataType(literal.getType())) {
                throw Util.FoundOne.NULL;
            }
            return (Void)super.visitLiteral(literal);
        }

        public Void visitCall(RexCall call) {
            if (!this.dialect.supportsDataType(call.getType())) {
                throw Util.FoundOne.NULL;
            }
            return (Void)super.visitCall(call);
        }

        public Void visitOver(RexOver over) {
            if (!this.dialect.supportsDataType(over.getType())) {
                throw Util.FoundOne.NULL;
            }
            return (Void)super.visitOver(over);
        }

        public Void visitFieldAccess(RexFieldAccess fieldAccess) {
            if (!this.dialect.supportsDataType(fieldAccess.getType())) {
                throw Util.FoundOne.NULL;
            }
            return (Void)super.visitFieldAccess(fieldAccess);
        }
    }
}

