/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.rules.AbstractJoinExtractFilterRule;
import org.apache.calcite.rel.rules.JoinExtractFilterRule;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.jdbc.HiveJdbcConverter;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc.JDBCAbstractSplitFilterRule;

public final class JDBCExtractJoinFilterRule
extends AbstractJoinExtractFilterRule {
    private static final AbstractJoinExtractFilterRule.Config DEFAULT = (AbstractJoinExtractFilterRule.Config)JoinExtractFilterRule.Config.DEFAULT.withOperandSupplier(b0 -> b0.operand(HiveJoin.class).inputs(new RelRule.OperandTransform[]{b1 -> b1.operand(HiveJdbcConverter.class).anyInputs(), b2 -> b2.operand(HiveJdbcConverter.class).anyInputs()})).withRelBuilderFactory(HiveRelFactories.HIVE_BUILDER).withDescription("JDBCExtractJoinFilterRule").as(AbstractJoinExtractFilterRule.Config.class);
    public static final JDBCExtractJoinFilterRule INSTANCE = new JDBCExtractJoinFilterRule();

    public JDBCExtractJoinFilterRule() {
        super(DEFAULT);
    }

    public boolean matches(RelOptRuleCall call) {
        Join join = (Join)call.rel(0);
        HiveJdbcConverter conv1 = (HiveJdbcConverter)call.rel(1);
        HiveJdbcConverter conv2 = (HiveJdbcConverter)call.rel(2);
        if (!conv1.getJdbcDialect().equals(conv2.getJdbcDialect())) {
            return false;
        }
        return JDBCAbstractSplitFilterRule.canSplitFilter(join.getCondition(), conv1.getJdbcDialect());
    }
}

